% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear2ph.R
\name{linear2ph}
\alias{linear2ph}
\title{Sieve maximum likelihood estimator (SMLE) for two-phase linear regression problems}
\usage{
linear2ph(
  y_unval = NULL,
  y = NULL,
  x_unval = NULL,
  x = NULL,
  z = NULL,
  b_spline = NULL,
  data = NULL,
  hn_scale = 1,
  se = TRUE,
  tol = 1e-04,
  max_iter = 1000,
  verbose = FALSE
)
}
\arguments{
\item{y_unval}{Column name of the error-prone or unvalidated continuous outcome. Subjects with missing values of \code{y_unval} are omitted from the analysis. This argument is required.}

\item{y}{Column name that stores the validated value of \code{y_unval} in the second phase. Subjects with missing values of \code{y} are considered as those not selected in the second phase. This argument is required.}

\item{x_unval}{Specifies the columns of the error-prone covariates. Subjects with missing values of \code{x_unval} are omitted from the analysis. This argument is required.}

\item{x}{Specifies the columns that store the validated values of \code{x_unval} in the second phase. Subjects with missing values of \code{x} are considered as those not selected in the second phase. This argument is required.}

\item{z}{Specifies the columns of the accurately measured covariates. Subjects with missing values of \code{z} are omitted from the analysis. This argument is optional.}

\item{b_spline}{Specifies the columns of the B-spline basis. Subjects with missing values of \code{b_spline} are omitted from the analysis. This argument is required.}

\item{data}{Specifies the name of the dataset. This argument is required.}

\item{hn_scale}{Specifies the scale of the perturbation constant in the variance estimation. For example, if \code{hn_scale = 0.5}, then the perturbation constant is \eqn{0.5n^{-1/2}}, where \eqn{n} is the first-phase sample size. The default value is \code{1}. This argument is optional.}

\item{se}{If \code{FALSE}, then the variances of the parameter estimators will not be estimated. The default value is \code{TRUE}. This argument is optional.}

\item{tol}{Specifies the convergence criterion in the EM algorithm. The default value is \code{1E-4}. This argument is optional.}

\item{max_iter}{Maximum number of iterations in the EM algorithm. The default number is \code{1000}. This argument is optional.}

\item{verbose}{If \code{TRUE}, then show details of the analysis. The default value is \code{FALSE}.}
}
\value{
\code{linear2ph()} returns an object of class \code{"linear2ph"}. The function \code{coef()} is used to obtain the coefficients of the fitted model. The function \code{summary()} is used to obtain and print a summary of results.

An object of class \code{"linear2ph"} is a list containing at least the following components:
\item{call}{the matched call.}
\item{coefficients}{A named vector of the linear regression coefficient estimates.}
\item{sigma}{The residual standard error.}
\item{covariance}{The covariance matrix of the linear regression coefficient estimates.}
\item{converge}{In parameter estimation, if the EM algorithm converges, then \code{converge = TRUE}. Otherwise, \code{converge = FALSE}.}
\item{converge_cov}{In variance estimation, if the EM algorithm converges, then \code{converge_cov = TRUE}. Otherwise, \code{converge_cov = FALSE}.}
}
\description{
Performs efficient semiparametric estimation for general two-phase measurement error models when there are errors in both the outcome and covariates. See pacakge vigenette for code examples.
}
\details{
Models for \code{linear2ph()} are specified through the arguments. The dataset input should at least contain columns for unvalidated error-prone outcome, validated error-prone outcome,
unvalidated error-prone covariate(s), validated error-prone covariate(s), and B-spline basis. B-spline basis can be generated from \code{splines::bs()} function, with argument \code{x}
being the unvalidated error-prone covariate(s). See vignette for options in tuning the B-spline basis.
}
\references{
Tao, R., Mercaldo, N. D., Haneuse, S., Maronge, J. M., Rathouz, P. J., Heagerty, P. J., & Schildcrout, J. S. (2021). Two-wave two-phase outcome-dependent sampling designs, with applications to longitudinal binary data. \emph{Statistics in Medicine, 40}(8), 1863–1876. https://doi.org/10.1002/sim.8876
}
\seealso{
\code{\link[=cv_linear2ph]{cv_linear2ph()}} to calculate the average predicted log likelihood of this function.
}
