% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slfm.r
\name{slfm}
\alias{slfm}
\title{Sparse Latent Factor Model (SLFM)}
\usage{
slfm(x, a = 2.1, b = 1.1, gamma_a = 1, gamma_b = 1,
  omega_0 = 0.01, omega_1 = 10, sample = 1000, burnin = round(0.25
  * sample), lag = 1, degenerate = FALSE)
}
\arguments{
\item{x}{matrix with the pre-processed data.}

\item{a}{positive shape parameter of the Inverse Gamma prior distribution (default = 2.1).}

\item{b}{positive scale parameter of the Inverse Gamma prior distribution (default = 1.1).}

\item{gamma_a}{positive 1st shape parameter of the Beta prior distribution (default = 1).}

\item{gamma_b}{positive 2nd shape parameter of the Beta prior distribution (default = 1).}

\item{omega_0}{prior variance of the spike mixture component (default = 0.01).}

\item{omega_1}{prior variance of the slab mixture component (default = 10).}

\item{sample}{sample size to be considered for inference after the burn in period (default = 1000).}

\item{burnin}{size of the burn in period in the MCMC algorithm (default = sample/4).}

\item{lag}{lag to build the chains based on spaced draws from the Gibbs sampler (defaul = 1).}

\item{degenerate}{logical argument (default = FALSE) indicating whether to use the degenerate version of 
the mixture prior for the factor loadings.}
}
\value{
x: data matrix.

q_star: matrix of MCMC chains for q_star parameter.

alpha: summary table of MCMC chains for alpha parameter.

lambda: summary table of MCMC chains for lambda parameter.

sigma: summary table of MCMC chains for sigma parameter.

classification: classification of each alpha (`present`, `marginal`, `absent`)
}
\description{
This function is used to fit a Bayesian Sparse
Latent Factor Model to evaluate patterns in gene expression data matrices.
}
\examples{
mat <- matrix(rnorm(2000), nrow = 20)
slfm(mat, sample = 1000)
}
\references{
DOI:10.18637/jss.v090.i09

DOI:10.1007/978-3-319-12454-4_15
}
