% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Slurm_collect.R
\name{Slurm_collect}
\alias{Slurm_collect}
\alias{Slurm_collect.slurm_job}
\title{Collect the results of a slurm job}
\usage{
Slurm_collect(...)

\method{Slurm_collect}{slurm_job}(x, any. = FALSE, wait = 10L, ...)
}
\arguments{
\item{...}{Further arguments passed to the method.}

\item{x}{An object of class \link{slurm_job}.}

\item{any.}{Logical. When \code{TRUE}, will collect any output available regardless
of whether the job is completed or not.}

\item{wait}{Integer scalar. Number of seconds to wait before checking the
state of a job if the first try returned \code{-1} (no job found).}
}
\value{
By default, it returns a concatenated list of the output files
generated by each job. If the job object has a hook, it will apply each hook
to the full list before returning. See \link{new_slurm_job}.
}
\description{
This function takes an object of class \code{slurm_job} and retrieves the results,
this is, combines the R objects generated by each job. Object of class
\code{slurm_job}.
}
\details{
If the given job has hooks, which is a list of functions, these will
be applied sequentially to the set of retrieved results before returning.
}
\examples{
\dontrun{
# Collecting a job after calling it
job <- Slurm_EvalQ(slurmR::WhoAmI(), njobs = 4, plan = "wait")
Slurm_collect(job)

# Collecting a job from a previous R session
job <- read_slurm_job("/path/to/a/job/tmp_dir")
Slurm_collect(job)
}
}
\seealso{
Other post submission: 
\code{\link{Slurm_clean}()},
\code{\link{Slurm_log}()},
\code{\link{status}()}
}
\concept{post submission}
