%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:12.
% Do NOT modify this file, instead modify the source (sma/R/Rmisc.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{id2image}

\alias{id2image}
\alias{image2id}
 
\title{Converting an id tag to a Set of Image Coordinates and Vice Versa}

\description{
 The function \code{id2image} converts an id tag of a gene supplied
 by a user into a set of image coordinates regarding the location of
 the gene being 
 considered. Conversion of image coordinates to an id tag is performed
 by \code{image2id}.
}

\usage{
id2image(X, layout)
image2id(x, layout)
}

\arguments{
 \item{X}{an integer value representing the id of a particular gene}
 \item{layout}{}
 \item{x}{a vector of 4 integer elements which make up the image
   coordinates of the gene.}
}
\details{
The image coordinates of a gene correspond to the gene's grid row and
grid column position within a slide, and the gene's row and column
position within a grid.  
}

\value{
  \code{id2image} returns a vector of 4 integer elements which is
  the set of image coordinates. 
  \code{image2id} returns an integer value which is the gene's id tag.
}

\author{Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu}}

\seealso{\code{\link{MouseArray}}}

\examples{data(MouseArray)
# mouse.setup <- init.grid()

id2image(1024, mouse.setup)
## You will see: [1]  1 3 11 16
## the grid in which gene 1024 can be found, is in row 1, column 3
## and the gene is located in row 11, column 16 of this particular grid.
 
image2id(c(2,4,6,8), mouse.setup)
## You will see: [1] 2906
## the gene located in row 6, column 8 in the grid that is in row 2 and
## column 4 is the 2906th gene of the data set.  
}

\keyword{image, id}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
