% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logrr.R
\name{logrr}
\alias{logrr}
\title{Log ratio of spatial densities}
\usage{
logrr(
  x,
  sigma = NULL,
  sigmacon = NULL,
  case = 2,
  nsim = 0,
  level = 0.9,
  alternative = "two.sided",
  ...,
  bwargs = list(),
  weights = NULL,
  edge = TRUE,
  varcov = NULL,
  at = "pixels",
  leaveoneout = TRUE,
  adjust = 1,
  diggle = FALSE,
  kernel = "gaussian",
  scalekernel = is.character(kernel),
  positive = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{
    Point pattern (object of class \code{"ppp"}).
  }

\item{sigma}{Standard deviation of isotropic smoothing
kernel for cases. Either a numerical value, or a function that
computes an appropriate value of \code{sigma}.}

\item{sigmacon}{Standard deviation of isotropic smoothing
kernel for controls.  Default is the same as 
\code{sigma}.}

\item{case}{The position of the name of the "case" group 
in \code{levels(x$marks)}.  The default is 2.  
\code{x$marks} is assumed to be a factor.  Automatic
conversion is attempted if it is not.}

\item{nsim}{The number of simulated data sets from which 
to construct the non-rejection envelopes under the random
labeling hypothesis.  Default is 0 (i.e., no
envelopes).}

\item{level}{The level used for the pointwise
non-rejection envelopes.}

\item{alternative}{The direction of the significance test
to identify potential clusters using a Monte Carlo test
based on the pointwise non-rejection envelopes.  Default is
\code{"two.sided"} (logrr != 0).  The values \code{"less"}
(logrr < 0) and \code{"greater"} (logrr > 0) are also valid.}

\item{...}{
    Additional arguments passed to \code{\link{pixellate.ppp}}
    and \code{\link{as.mask}} to determine
    the pixel resolution, or passed to \code{sigma} if it is a function.
  }

\item{bwargs}{A list of arguments for the bandwidth 
function supplied to \code{sigma} and \code{sigmacon},
if applicable.}

\item{weights}{
    Optional weights to be attached to the points.
    A numeric vector, numeric matrix, an \code{expression},
    or a pixel image.
  }

\item{edge}{
    Logical value indicating whether to apply edge correction.
  }

\item{varcov}{
    Variance-covariance matrix of anisotropic smoothing kernel.
    Incompatible with \code{sigma}.
  }

\item{at}{
    String specifying whether to compute the intensity values
    at a grid of pixel locations (\code{at="pixels"}) or
    only at the points of \code{x} (\code{at="points"}).
  }

\item{leaveoneout}{
    Logical value indicating whether to compute a leave-one-out
    estimator. Applicable only when \code{at="points"}.
  }

\item{adjust}{
    Optional. Adjustment factor for the smoothing parameter.
  }

\item{diggle}{
    Logical. If \code{TRUE}, use the Jones-Diggle improved edge correction,
    which is more accurate but slower to compute than the default
    correction.
  }

\item{kernel}{
    The smoothing kernel.
    A character string specifying the smoothing kernel
    (current options are \code{"gaussian"}, \code{"epanechnikov"},
    \code{"quartic"} or \code{"disc"}),
    or a pixel image (object of class \code{"im"})
    containing values of the kernel, or a \code{function(x,y)} which
    yields values of the kernel.
  }

\item{scalekernel}{
    Logical value.
    If \code{scalekernel=TRUE}, then the kernel will be rescaled
    to the bandwidth determined by \code{sigma} and \code{varcov}:
    this is the default behaviour when \code{kernel} is a character string.
    If \code{scalekernel=FALSE}, then \code{sigma} and \code{varcov}
    will be ignored: this is the default behaviour when \code{kernel} is a
    function or a pixel image.
  }

\item{positive}{
    Logical value indicating whether to force all density values to
    be positive numbers. Default is \code{FALSE}.
  }

\item{verbose}{
    Logical value indicating whether to issue warnings
    about numerical problems and conditions.
  }
}
\value{
The function produces an object of type 
  \code{logrrenv}.  Its components are similar to those 
  returned by the \code{density.ppp} function from the 
  \code{spatstat.core} package, with the intensity values 
  replaced by the log ratio of spatial densities of f and
  g.  Includes an array \code{simr} of dimension c(nx, 
  ny, nsim + 1), where nx and ny are the number of x and 
  y grid points used to estimate the spatial density. 
  \code{simr[,,1]} is the log ratio of spatial densities 
  for the observed data, and the remaining \code{nsim} 
  elements in the third dimension of the array are the 
  log ratios of spatial densities from a new ppp 
  simulated under the random labeling hypothesis.
}
\description{
\code{logrr} computes the log ratio of spatial density 
functions for cases and controls.  The numerator in this 
ratio is related to the "cases" and the denominator to 
the "controls".  If \code{nsim > 0}, then pointwise 
non-rejection envelopes are used to assess potential 
clustering of cases and controls relative to each other.
}
\details{
The \code{plot} function makes it easy to visualize the
log ratio of spatial densities (if \code{nsim = 0}) or
the regions where the log ratio deviates farther from
than what is expected under the random labeling 
hypothesis (i.e., the locations of potential clustering).
The shaded regions indicate the locations of potential
clustering.

The \code{two.sided} alternative test assesses 
  whether the observed ratio of log densities deviates 
  more than what is expected under the random labeling 
  hypothesis.  When the test is significant, this 
  suggests that the cases and controls are clustered, 
  relative to the other.  The \code{greater} alternative 
  assesses whehter the cases are more clustered than
  the controls.  The \code{less} alternative
  assesses whether the controls are more clustered than 
  the cases.  If the estimated density of the case or 
  control group becomes too small, this function may 
  produce warnings due to numerical underflow. Increasing
  the bandwidth (sigma) may help.
}
\examples{
data(grave)
r = logrr(grave)
plot(r)
r2 = logrr(grave, sigma = spatstat.core::bw.scott)
plot(r2)
rsim = logrr(grave, nsim = 9)
plot(rsim)
}
\references{
Waller, L.A. and Gotway, C.A. (2005). Applied
  Spatial Statistics for Public Health Data. Hoboken, NJ:
  Wiley.  
  
  Kelsall, Julia E., and Peter J. Diggle. "Kernel
  estimation of relative risk." Bernoulli (1995): 3-16. 
  
  Kelsall, Julia E., and Peter J. Diggle. "Non-parametric
  estimation of spatial variation in relative risk." 
  Statistics in Medicine 14.21-22 (1995): 2335-2342.
}
\author{
Joshua French (and a small chunk by the authors 
  of the \code{\link[spatstat.core]{density.ppp}}) function 
  for consistency with the default behavior of that 
  function)
}
