% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dCohen.R
\name{dCohen}
\alias{dCohen}
\title{Cohen's d}
\usage{
dCohen(x, y = NULL, mu0 = 0, paired = FALSE)
}
\arguments{
\item{x}{vector with (numeric) data}

\item{y}{for two-sample tests, a vector with (numeric) data for group 2}

\item{mu0}{for one-sample tests, the number to test against}

\item{paired}{TRUE for a paired two-sample t-test, FALSE for an independent
sample t-test}
}
\value{
value of Cohen's d
}
\description{
Calculate Cohen's d for one-sample t tests or two-sample independent tests or
two-sample paired t-tests
}
\examples{
#one-sample
x=c(1:10,5,6,3:8)
dCohen(x,mu0=7)

#two-sample independent
y=1:15
dCohen(x,y)

#two-sample paired
dCohen(x,1:18,paired=TRUE)
}
