\name{elev.test}

\alias{elev.test}

\title{One-sample test of a (standardised) major axis elevation}

\description{Test if the elevation of a major axis or standardised
 major axis equals a specific value}

\usage{
    elev.test(y, x, test.value = 0, data = NULL, alpha = 0.05,
        method = 'SMA', V = matrix(0,2,2) )
}

\arguments{
  \item{y}{The Y-variable}
  \item{x}{The X-variable}
  \item{test.value}{The hypothesised value of the elevation (default value is 0)}
  \item{data}{ (optional) data frame containing the data }
  \item{alpha}{The desired confidence level for the 100(1-alpha)\% confidence interval for the common slope. (Default value is 0.05, which returns a 95\% confidence interval.)}
  \item{method}{ The line fitting method:
    \describe{
      \item{'OLS' or 0}{linear regression}
      \item{'SMA' or 1}{standardised major axis (this is the default)}
      \item{'MA' or 2}{major axis}
    }
  }
  \item{V}{The estimated variance matrix of measurement error. Default is that there is no measurement error.}
  }

\value{
    \item{t}{The test statistic - a t statistic.}
    \item{p}{The P-value, taken from the \eqn{t_{n-2}}{t_(n-2)}-distribution. This is an exact test if residuals are normally distributed.}
    \item{test.value}{The hypothesised value of the elevation}
    \item{a}{The estimated elevation}
    \item{ci}{A 100(1-alpha)\% CI for the slope.}
  }

\details{
Tests if the line relating y to x has an elevation equal to test.value (which has a default value of 0). The line can be a linear regression line, major axis or standardised major axis (as selected using the input argument choice). The test is carried out usinga t-statistic, comparing the difference between estimated and hypothesised elevation to the standard error of elevation. As described in Warton et al (in review).

A confidence interval for the elevation is also returned, again using the t-distribution.

If measurement error is present, it can be corrected for through use of the input argument V, which makes adjustments to the estimated sample variances and covariances then proceeds with the same method of inference. Note, however, that this method is only approximate (see Warton et al in review for more details).

The test assumes the following:
  \enumerate{
    \item y and x are linearly related
    \item residuals independently follow a normal distribution with equal variance at all points along the line
  }      

These assumptions can be visually checked by plotting residuals against fitted axis scores, and by constructing a Q-Q plot of residuals against a normal distribution.  An appropriate residual variable is y-bx, and for fitted axis scores use x (for linear regression), y+bx (for SMA) or by+x (for MA), where b represents the estimated slope.
}
\references{ Warton D. I., Wright I. J., Falster D. S. and Westoby M. (2006) A review of bivariate line-fitting methods for allometry.  \emph{Biological Reviews} (in press) }

\author{ Warton, D. \email{David.Warton@unsw.edu.au}, translated to R by Ormerod, J. 2005-12-08 }

\seealso{\code{\link{line.cis}}, \code{\link{slope.test}} }

\examples{
#load the leaflife dataset:
data(leaflife)

#consider only the low rainfall sites:
leaf.low.rain=leaflife[leaflife$rain=="low",]

#construct a plot
plot(log10(leaf.low.rain$lma), log10(leaf.low.rain$longev),
   xlab="leaf mass per area [log scale]", ylab="leaf longevity [log scale]")
    
#test if the SMA elevation is 0 for leaf longevity vs LMA
elev.test(log10(leaf.low.rain$lma), log10(leaf.low.rain$longev),
   data = leaf.low.rain )

#test if the MA elevation is 2
elev.test(log10(leaf.low.rain$lma), log10(leaf.low.rain$longev),
   data = leaf.low.rain, test.value = 2, method = "MA")
}

\keyword{ htest }
