% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm4.R
\name{sm4_encrypt_ecb}
\alias{sm4_encrypt_ecb}
\alias{sm4_decrypt_ecb}
\alias{sm4_encrypt_cbc}
\alias{sm4_decrypt_cbc}
\title{SM4 Encrypt/Decrypt}
\usage{
sm4_encrypt_ecb(input_data, key)

sm4_decrypt_ecb(input_data, key)

sm4_encrypt_cbc(input_data, key, iv)

sm4_decrypt_cbc(input_data, key, iv)
}
\arguments{
\item{input_data}{data bytes to be encrypted, must be a raw vector}

\item{key}{the key, must be a raw vector of length 16}

\item{iv}{the initialization vector, must be a raw vector of 16}
}
\value{
\describe{
  \item{\link{sm4_encrypt_ecb}}{returns a raw vector of the cipher text using ecb mode}
  \item{\link{sm4_decrypt_ecb}}{returns a raw vector of the plain text}
  \item{\link{sm4_encrypt_cbc}}{returns a raw vector of the cipher text using cbc mode}
  \item{\link{sm4_decrypt_cbc}}{returns a raw vector of the plain text}
}
}
\description{
The SM4 algorithm is a block symmetric encryption algorithm with a block size
and key length of 128 bits. Compared to the SM2 algorithm, it has higher
encryption and decryption efficiency and can be used to encrypt larger amounts
of data. SM4 supports both the ECB (Electronic Codebook) mode and the
CBC (Cipher Block Chaining) mode. The ECB mode is a simple block cipher
encryption mode that encrypts each data block independently without depending
on other blocks. The CBC mode, on the other hand, is a chained block cipher
encryption mode where the encryption of each block depends on the previous
ciphertext block. Therefore, it requires an initialization vector (IV) of
the same 128-bit length. The CBC mode provides higher security than the ECB mode.
}
\examples{
## ecb mode
data <- 'abc' |> charToRaw()
key <- '1234567812345678' |> charToRaw()
iv <- '0000000000000000' |> charToRaw()
enc <- sm4_encrypt_ecb(data, key)
enc
dec <- sm4_decrypt_ecb(enc, key)
dec
## cbc mode
enc <- sm4_encrypt_cbc(data, key, iv)
enc
dec <- sm4_decrypt_cbc(enc, key, iv)
dec
}
