% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.ellipse.R
\name{dist.ellipse}
\alias{dist.ellipse}
\title{Compute minor axis distance of ellipse}
\usage{
dist.ellipse(coords, shape, angle)
}
\arguments{
\item{coords}{An \eqn{N \times 2} matrix of coordinates}

\item{shape}{The ratio of the major axis to the minor
axis of the ellipse}

\item{angle}{The angle of the ellipse in the range [0,
180).}
}
\value{
A matrix of distances between each coordinate and
  all other coordinates (and itself).  Each row contains
  the distances for a coordinate.
}
\description{
\code{dist.ellipse} computes the length of the minor axis
needed for an ellipse of a certain \code{shape} and
\code{angle} to intersect each of the other coordinates
from a starting coordinate.
}
\examples{
data(nydf)
coords <- as.matrix(nydf[, c("x", "y")])
d <- dist.ellipse(coords, 4, 15)
}
