\name{mcmcSummary}
\alias{mcmcSummary}
\title{Summarise and plot tabular MCMC output}
\description{
  This function summarises and plots tabular MCMC output such as that
  generated by the function \code{\link{normgibbs}}.
}
\usage{
mcmcSummary(mat, rows = 4, lag.max=100, bins=30, show = TRUE, plot = TRUE, truth = NULL) 
}
\arguments{
  \item{mat}{Matrix of MCMC output, where the columns represent
    variables and the rows represent iterations.}
  \item{rows}{Number of variables to plot per page on the graphics
    device.}
  \item{lag.max}{Maximum lag for the ACF plots.}
  \item{bins}{Approximate number of bins to use for the histograms.}
  \item{show}{If \code{TRUE}, will display numerical summaries on the R
    console.}
  \item{plot}{If \code{TRUE}, will plot graphical summaries on the
    default graphics device.}
  \item{truth}{Optional vector of "true values", one for each variable, for the case where an algorithm is being tested on synthetic data for known parameters. The plots will be annotated with a red line indicating the true value.}
  }
\value{
  An R \code{\link{summary}} object.
}
\seealso{\code{\link{normgibbs}}, \code{\link{summary}}, \code{\link{acf}}}
\examples{
out=normgibbs(N=1000,n=15,a=3,b=11,cc=10,d=1/100,xbar=25,ssquared=20)
names(out)=c("mu","tau")
mcmcSummary(out,rows=2,bins=10,truth=c(25,1/20))
}

\keyword{smfsb}
