% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ves.R
\name{ves}
\alias{ves}
\title{Vector Exponential Smoothing in SSOE state-space model}
\usage{
ves(data, model = "ANN", persistence = c("group", "independent",
  "dependent"), transition = c("group", "independent", "dependent"),
  phi = c("group", "individual"), initial = c("individual", "group"),
  initialSeason = c("group", "individual"), cfType = c("likelihood",
  "diagonal", "trace"), ic = c("AICc", "AIC", "BIC"), h = 10,
  holdout = FALSE, intervals = c("none", "conditional", "unconditional",
  "independent"), level = 0.95, cumulative = FALSE,
  intermittent = c("none", "auto", "fixed", "probability"),
  bounds = c("admissible", "none"), silent = c("all", "graph", "output",
  "none"), ...)
}
\arguments{
\item{data}{The matrix with data, where series are in columns and
observations are in rows.}

\item{model}{The type of ETS model. Can consist of 3 or 4 chars: \code{ANN},
\code{AAN}, \code{AAdN}, \code{AAA}, \code{AAdA}, \code{MMdM} etc.
\code{ZZZ} means that the model will be selected based on the chosen
information criteria type.
ATTENTION! ONLY PURE ADDITIVE AND PURE MULTIPLICATIVE MODELS ARE CURRENTLY
AVAILABLE + NO MODEL SELECTION IS AVAILABLE AT THIS STAGE!
Pure multiplicative models are done as additive model applied to log(data).

Also \code{model} can accept a previously estimated VES model and use all its
parameters.

Keep in mind that model selection with "Z" components uses Branch and Bound
algorithm and may skip some models that could have slightly smaller
information criteria.}

\item{persistence}{Persistence matrix \eqn{G}, containing smoothing
parameters. Can be:
\itemize{
\item \code{independent} - each series has its own smoothing parameters
and no interactions are modelled (all the other values in the matrix are set
to zero);
\item \code{dependent} - each series has its own smoothing parameters, but
interactions between the series are modelled (the whole matrix is estimated);
\item \code{group} each series has the same smoothing parameters for respective
components (the values of smoothing parameters are repeated, all the other values
in the matrix are set to zero).
\item provided by user as a vector or as a matrix. The value is used by the model.
}}

\item{transition}{Transition matrix \eqn{F}. Can be:
\itemize{
\item \code{independent} - each series has its own preset transition matrix
and no interactions are modelled (all the other values in the matrix are set
to zero);
\item \code{dependent} - each series has its own transition matrix, but
interactions between the series are modelled (the whole matrix is estimated). The
estimated model behaves similar to VAR in this case;
\item \code{group} each series has the same transition matrix for respective
components (the values are repeated, all the other values in the matrix are set to
zero).
\item provided by user as a vector or as a matrix. The value is used by the model.
}}

\item{phi}{In cases of damped trend this parameter defines whether the \eqn{phi}
should be estimated separately for each series (\code{individual}) or for the whole
set (\code{group}). If vector or a value is provided here, then it is used by the
model.}

\item{initial}{Can be either character or a vector / matrix of initial states.
If it is character, then it can be \code{"individual"}, individual values of
the initial non-seasonal components are used, or \code{"group"}, meaning that
the initials for all the time series are set to be equal to the same value.
If vector of states is provided, then it is automatically transformed into
a matrix, assuming that these values are provided for the whole group.}

\item{initialSeason}{Can be either character or a vector / matrix of initial
states. Treated the same way as \code{initial}. This means that different time
series may share the same initial seasonal component.}

\item{cfType}{Type of Cost Function used in optimization. \code{cfType} can
be:
\itemize{
\item \code{likelihood} - which assumes the minimisation of the determinant
of the covariance matrix of errors between the series. This implies that the
series could be correlated;
\item \code{diagonal} - the covariance matrix is assumed to be diagonal with
zeros off the diagonal. The determinant of this matrix is just a product of
variances. This thing is minimised in this situation in logs.
\item \code{trace} - the trace of the covariance matrix. The sum of variances
is minimised in this case.
}}

\item{ic}{The information criterion used in the model selection procedure.}

\item{h}{Length of forecasting horizon.}

\item{holdout}{If \code{TRUE}, holdout sample of size \code{h} is taken from
the end of the data.}

\item{intervals}{Type of intervals to construct. NOT AVAILABLE YET!

This can be:

\itemize{
\item \code{none}, aka \code{n} - do not produce prediction
intervals.
\item \code{conditional}, \code{c} - produces multidimensional elliptic
intervals for each step ahead forecast.
\item \code{unconditional}, \code{u} - produces separate bounds for each series
based on ellipses for each step ahead. These bounds correspond to min and max
values of the ellipse assuming that all the other series but one take values in
the centre of the ellipse. This leads to less accurate estimates of bounds
(wider intervals than needed), but these could still be useful.
\item \code{independent}, \code{i} - produces intervals based on variances of
each separate series. This does not take vector structure into account.
}
The parameter also accepts \code{TRUE} and \code{FALSE}. The former means that
conditional intervals are constructed, while the latter is equivalent to
\code{none}.}

\item{level}{Confidence level. Defines width of prediction interval.}

\item{cumulative}{If \code{TRUE}, then the cumulative forecast and prediction
intervals are produced instead of the normal ones. This is useful for
inventory control systems.}

\item{intermittent}{Defines type of intermittent model used. Can be:
\itemize{
\item \code{none}, meaning that the data should be considered as non-intermittent;
\item \code{fixed}, taking into account constant Bernoulli distribution of
demand occurrences;
\item \code{tsb}, based on Teunter et al., 2011 method.
\item \code{auto} - automatic selection of intermittency type based on information
criteria. The first letter can be used instead.
}}

\item{bounds}{What type of bounds to use in the model estimation. The first
letter can be used instead of the whole word. Currently only \code{"admissible"}
bounds are available.}

\item{silent}{If \code{silent="none"}, then nothing is silent, everything is
printed out and drawn. \code{silent="all"} means that nothing is produced or
drawn (except for warnings). In case of \code{silent="graph"}, no graph is
produced. If \code{silent="legend"}, then legend of the graph is skipped.
And finally \code{silent="output"} means that nothing is printed out in the
console, but the graph is produced. \code{silent} also accepts \code{TRUE}
and \code{FALSE}. In this case \code{silent=TRUE} is equivalent to
\code{silent="all"}, while \code{silent=FALSE} is equivalent to
\code{silent="none"}. The parameter also accepts first letter of words ("n",
"a", "g", "l", "o").}

\item{...}{Other non-documented parameters. For example \code{FI=TRUE} will
make the function also produce Fisher Information matrix, which then can be
used to calculated variances of smoothing parameters and initial states of
the model.}
}
\value{
Object of class "vsmooth" is returned. It contains the following list of
values:
\itemize{
\item \code{model} - The name of the fitted model;
\item \code{timeElapsed} - The time elapsed for the construction of the model;
\item \code{states} - The matrix of states with components in columns and time in rows;
\item \code{persistence} - The persistence matrix;
\item \code{transition} - The transition matrix;
\item \code{measurement} - The measurement matrix;
\item \code{phi} - The damping parameter value;
\item \code{coefficients} - The vector of all the estimated coefficients;
\item \code{initial} - The initial values of the non-seasonal components;
\item \code{initialSeason} - The initial values of the seasonal components;
\item \code{nParam} - The number of estimated parameters;
\item \code{actuals} - The matrix with the original data;
\item \code{fitted} - The matrix of the fitted values;
\item \code{holdout} - The matrix with the holdout values (if \code{holdout=TRUE} in
the estimation);
\item \code{residuals} - The matrix of the residuals of the model;
\item \code{Sigma} - The covariance matrix of the errors (estimated with the correction
for the number of degrees of freedom);
\item \code{forecast} - The matrix of point forecasts;
\item \code{PI} - The bounds of the prediction intervals;
\item \code{intervals} - The type of the constructed prediction intervals;
\item \code{level} - The level of the confidence for the prediction intervals;
\item \code{ICs} - The values of the information criteria;
\item \code{logLik} - The log-likelihood function;
\item \code{cf} - The value of the cost function;
\item \code{cfType} - The type of the used cost function;
\item \code{accuracy} - the values of the error measures. Currently not available.
}
}
\description{
Function constructs vector ETS model and returns forecast, fitted values, errors
and matrix of states along with other useful variables.
}
\details{
Function estimates vector ETS in a form of the Single Source of Error State-space
model of the following type:

\deqn{
\mathbf{y}_{t} = \mathbf{o}_{t} (\mathbf{W} \mathbf{v}_{t-l} + \mathbf{x}_t
\mathbf{a}_{t-1} + \mathbf{\epsilon}_{t})
}{
y_{t} = o_{t} (W v_{t-l} + x_t a_{t-1} + \epsilon_{t})
}

\deqn{
\mathbf{v}_{t} = \mathbf{F} \mathbf{v}_{t-l} + \mathbf{G}
\mathbf{\epsilon}_{t}
}{
v_{t} = F v_{t-l} + G \epsilon_{t}
}

\deqn{\mathbf{a}_{t} = \mathbf{F_{X}} \mathbf{a}_{t-1} + \mathbf{G_{X}}
\mathbf{\epsilon}_{t} / \mathbf{x}_{t}}{a_{t} = F_{X} a_{t-1} + G_{X} \epsilon_{t}
/ x_{t}}

Where \eqn{y_{t}} is the vector of time series on observation \eqn{t}, \eqn{o_{t}}
is the vector of Bernoulli distributed random variable (in case of normal data it
becomes unit vector for all observations), \eqn{\mathbf{v}_{t}} is the matrix of
states and \eqn{l} is the matrix of lags, \eqn{\mathbf{x}_t} is the vector of
exogenous variables. \eqn{\mathbf{W}} is the measurement matrix, \eqn{\mathbf{F}}
is the transition matrix and \eqn{\mathbf{G}} is the persistence matrix.
Finally, \eqn{\epsilon_{t}} is the vector of error terms.

Conventionally we formulate values as:

\deqn{\mathbf{y}'_t = (y_{1,t}, y_{2,t}, \dots, y_{m,t})}{y_t = (y_{1,t}, y_{2,t},
\dots, y_{m,t}),}
where \eqn{m} is the number of series in the group.
\deqn{\mathbf{v}'_t = (v_{1,t}, v_{2,t}, \dots, v_{m,t})}{v'_t = (v_{1,t}, v_{2,t},
\dots, v_{m,t}),}
where \eqn{v_{i,t}} is vector of components for i-th time series.
\deqn{\mathbf{W}' = (w_{1}, \dots , 0;
\vdots , \ddots , \vdots;
0 , \vdots , w_{m})}{W' = (w_{1}, ... , 0;
... , ... , ...;
0 , ... , w_{m})} is matrix of measurement vectors.

For the details on the additive model see Hyndman et al. (2008),
chapter 17.

In case of multiplicative model, instead of the vector y_t we use its logarithms.
As a result the multiplicative model is much easier to work with.
}
\examples{

Y <- ts(cbind(rnorm(100,100,10),rnorm(100,75,8)),frequency=12)

# The simplest model applied to the data with the default values
ves(Y,model="ANN",h=10,holdout=TRUE)

# Damped trend model with the dependent persistence
ves(Y,model="AAdN",persistence="d",h=10,holdout=TRUE)

# Multiplicative damped trend model with individual phi
ves(Y,model="MMdM",persistence="i",h=10,holdout=TRUE,initialSeason="g")

}
\references{
\itemize{
\item de Silva A,, Hyndman R.J. and Snyder, R.D. (2010). The vector
innovations structural time series framework: a simple approach to
multivariate forecasting. Statistical Modelling, 10 (4), pp.353-374
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \url{http://www.exponentialsmoothing.net}.
}
}
\seealso{
\code{\link[smooth]{es}, \link[forecast]{ets}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{multivariate}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
