% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothCombine.R
\name{smoothCombine}
\alias{smoothCombine}
\title{Combination of forecasts of state space models}
\usage{
smoothCombine(y, models = NULL, initial = c("optimal", "backcasting"),
  ic = c("AICc", "AIC", "BIC", "BICc"), loss = c("MSE", "MAE", "HAM",
  "MSEh", "TMSE", "GTMSE", "MSCE"), h = 10, holdout = FALSE,
  cumulative = FALSE, interval = c("none", "parametric", "likelihood",
  "semiparametric", "nonparametric"), level = 0.95, bins = 200,
  intervalCombine = c("quantile", "probability"),
  occurrence = c("none", "auto", "fixed", "general", "odds-ratio",
  "inverse-odds-ratio", "probability"), oesmodel = "MNN",
  bounds = c("admissible", "none"), silent = c("all", "graph",
  "legend", "output", "none"), xreg = NULL, xregDo = c("use",
  "select"), initialX = NULL, updateX = FALSE, persistenceX = NULL,
  transitionX = NULL, ...)
}
\arguments{
\item{y}{Vector or ts object, containing data needed to be forecasted.}

\item{models}{List of the estimated smooth models to use in the
combination. If \code{NULL}, then all the models are estimated
in the function.}

\item{initial}{Can be \code{"optimal"}, meaning that the initial
states are optimised, or \code{"backcasting"}, meaning that the
initials are produced using backcasting procedure.}

\item{ic}{The information criterion used in the model selection procedure.}

\item{loss}{The type of Loss Function used in optimization. \code{loss} can
be: \code{MSE} (Mean Squared Error), \code{MAE} (Mean Absolute Error),
\code{HAM} (Half Absolute Moment), \code{TMSE} - Trace Mean Squared Error,
\code{GTMSE} - Geometric Trace Mean Squared Error, \code{MSEh} - optimisation
using only h-steps ahead error, \code{MSCE} - Mean Squared Cumulative Error.
If \code{loss!="MSE"}, then likelihood and model selection is done based
on equivalent \code{MSE}. Model selection in this cases becomes not optimal.

There are also available analytical approximations for multistep functions:
\code{aMSEh}, \code{aTMSE} and \code{aGTMSE}. These can be useful in cases
of small samples.

Finally, just for fun the absolute and half analogues of multistep estimators
are available: \code{MAEh}, \code{TMAE}, \code{GTMAE}, \code{MACE}, \code{TMAE},
\code{HAMh}, \code{THAM}, \code{GTHAM}, \code{CHAM}.}

\item{h}{Length of forecasting horizon.}

\item{holdout}{If \code{TRUE}, holdout sample of size \code{h} is taken from
the end of the data.}

\item{cumulative}{If \code{TRUE}, then the cumulative forecast and prediction
interval are produced instead of the normal ones. This is useful for
inventory control systems.}

\item{interval}{Type of interval to construct. This can be:

\itemize{
\item \code{"none"}, aka \code{"n"} - do not produce prediction
interval.
\item \code{"parametric"}, \code{"p"} - use state-space structure of ETS. In
case of mixed models this is done using simulations, which may take longer
time than for the pure additive and pure multiplicative models. This type
of interval relies on unbiased estimate of in-sample error variance, which
divides the sume of squared errors by T-k rather than just T.
\item \code{"likelihood"}, \code{"l"} - these are the same as \code{"p"}, but
relies on the biased estimate of variance from the likelihood (division by
T, not by T-k).
\item \code{"semiparametric"}, \code{"sp"} - interval based on covariance
matrix of 1 to h steps ahead errors and assumption of normal / log-normal
distribution (depending on error type).
\item \code{"nonparametric"}, \code{"np"} - interval based on values from a
quantile regression on error matrix (see Taylor and Bunn, 1999). The model
used in this process is e[j] = a j^b, where j=1,..,h.
}
The parameter also accepts \code{TRUE} and \code{FALSE}. The former means that
parametric interval are constructed, while the latter is equivalent to
\code{none}.
If the forecasts of the models were combined, then the interval are combined
quantile-wise (Lichtendahl et al., 2013).}

\item{level}{Confidence level. Defines width of prediction interval.}

\item{bins}{The number of bins for the prediction interval.
The lower value means faster work of the function, but less
precise estimates of the quantiles. This needs to be an even
number.}

\item{intervalCombine}{How to average the prediction interval:
quantile-wise (\code{"quantile"}) or probability-wise
(\code{"probability"}).}

\item{occurrence}{The type of model used in probability estimation. Can be
\code{"none"} - none,
\code{"fixed"} - constant probability,
\code{"general"} - the general Beta model with two parameters,
\code{"odds-ratio"} - the Odds-ratio model with b=1 in Beta distribution,
\code{"inverse-odds-ratio"} - the model with a=1 in Beta distribution,
\code{"direct"} - the TSB-like (Teunter et al., 2011) probability update
mechanism a+b=1,
\code{"auto"} - the automatically selected type of occurrence model.}

\item{oesmodel}{The type of ETS model used for the modelling of the time varying
probability. Object of the class "oes" can be provided here, and its parameters
would be used in iETS model.}

\item{bounds}{What type of bounds to use in the model estimation. The first
letter can be used instead of the whole word.}

\item{silent}{If \code{silent="none"}, then nothing is silent, everything is
printed out and drawn. \code{silent="all"} means that nothing is produced or
drawn (except for warnings). In case of \code{silent="graph"}, no graph is
produced. If \code{silent="legend"}, then legend of the graph is skipped.
And finally \code{silent="output"} means that nothing is printed out in the
console, but the graph is produced. \code{silent} also accepts \code{TRUE}
and \code{FALSE}. In this case \code{silent=TRUE} is equivalent to
\code{silent="all"}, while \code{silent=FALSE} is equivalent to
\code{silent="none"}. The parameter also accepts first letter of words ("n",
"a", "g", "l", "o").}

\item{xreg}{The vector (either numeric or time series) or the matrix (or
data.frame) of exogenous variables that should be included in the model. If
matrix included than columns should contain variables and rows - observations.
Note that \code{xreg} should have number of observations equal either to
in-sample or to the whole series. If the number of observations in
\code{xreg} is equal to in-sample, then values for the holdout sample are
produced using \link[smooth]{es} function.}

\item{xregDo}{The variable defines what to do with the provided xreg:
\code{"use"} means that all of the data should be used, while
\code{"select"} means that a selection using \code{ic} should be done.
\code{"combine"} will be available at some point in future...}

\item{initialX}{The vector of initial parameters for exogenous variables.
Ignored if \code{xreg} is NULL.}

\item{updateX}{If \code{TRUE}, transition matrix for exogenous variables is
estimated, introducing non-linear interactions between parameters.
Prerequisite - non-NULL \code{xreg}.}

\item{persistenceX}{The persistence vector \eqn{g_X}, containing smoothing
parameters for exogenous variables. If \code{NULL}, then estimated.
Prerequisite - non-NULL \code{xreg}.}

\item{transitionX}{The transition matrix \eqn{F_x} for exogenous variables. Can
be provided as a vector. Matrix will be formed using the default
\code{matrix(transition,nc,nc)}, where \code{nc} is number of components in
state vector. If \code{NULL}, then estimated. Prerequisite - non-NULL
\code{xreg}.}

\item{...}{This currently determines nothing.

\itemize{
\item \code{timeElapsed} - time elapsed for the construction of the model.
\item \code{initialType} - type of the initial values used.
\item \code{fitted} - fitted values of ETS.
\item \code{quantiles} - the 3D array of produced quantiles if \code{interval!="none"}
with the dimensions: (number of models) x (bins) x (h).
\item \code{forecast} - point forecast of ETS.
\item \code{lower} - lower bound of prediction interval. When \code{interval="none"}
then NA is returned.
\item \code{upper} - higher bound of prediction interval. When \code{interval="none"}
then NA is returned.
\item \code{residuals} - residuals of the estimated model.
\item \code{s2} - variance of the residuals (taking degrees of freedom into account).
\item \code{interval} - type of interval asked by user.
\item \code{level} - confidence level for interval.
\item \code{cumulative} - whether the produced forecast was cumulative or not.
\item \code{y} - original data.
\item \code{holdout} - holdout part of the original data.
\item \code{occurrence} - model of the class "oes" if the occurrence model was estimated.
If the model is non-intermittent, then occurrence is \code{NULL}.
\item \code{xreg} - provided vector or matrix of exogenous variables. If \code{xregDo="s"},
then this value will contain only selected exogenous variables.
\item \code{updateX} - boolean, defining, if the states of exogenous variables were
estimated as well.
\item \code{ICs} - values of information criteria of the model. Includes AIC, AICc, BIC and BICc.
\item \code{accuracy} - vector of accuracy measures for the holdout sample. In
case of non-intermittent data includes: MPE, MAPE, SMAPE, MASE, sMAE,
RelMAE, sMSE and Bias coefficient (based on complex numbers). In case of
intermittent data the set of errors will be: sMSE, sPIS, sCE (scaled
cumulative error) and Bias coefficient.
}}
}
\description{
Function constructs ETS, SSARIMA, CES, GUM and SMA and combines their
forecasts using IC weights.
}
\details{
The combination of these models using information criteria weights is
possible because they are all formulated in Single Source of Error
framework. Due to the the complexity of some of the models, the
estimation process may take some time. So be patient.

The prediction interval are combined either probability-wise or
quantile-wise (Lichtendahl et al., 2013), which may take extra time,
because we need to produce all the distributions for all the models.
This can be sped up with the smaller value for bins parameter, but
the resulting interval may be imprecise.
}
\examples{

library(Mcomp)

ourModel <- smoothCombine(M3[[578]],interval="p")
plot(ourModel)

# models parameter accepts either previously estimated smoothCombine
# or a manually formed list of smooth models estimated in sample:
smoothCombine(M3[[578]],models=ourModel)

\dontrun{models <- list(es(M3[[578]]), sma(M3[[578]]))
smoothCombine(M3[[578]],models=models)
}

}
\references{
\itemize{
\item Snyder, R. D., 1985. Recursive Estimation of Dynamic Linear Models.
Journal of the Royal Statistical Society, Series B (Methodological) 47 (2), 272-276.
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \url{http://dx.doi.org/10.1007/978-3-540-71918-2}.
}

\itemize{
\item Kolassa, S. (2011) Combining exponential smoothing forecasts using Akaike
weights. International Journal of Forecasting, 27, pp 238 - 251.
}

\itemize{
\item Taylor, J.W. and Bunn, D.W. (1999) A Quantile Regression Approach to
Generating Prediction Intervals. Management Science, Vol 45, No 2, pp
225-237.
\item Lichtendahl Kenneth C., Jr., Grushka-Cockayne Yael, Winkler
Robert L., (2013) Is It Better to Average Probabilities or
Quantiles? Management Science 59(7):1594-1611. DOI:
[10.1287/mnsc.1120.1667](https://doi.org/10.1287/mnsc.1120.1667)
}
}
\seealso{
\code{\link[smooth]{es}, \link[smooth]{auto.ssarima},
\link[smooth]{auto.ces}, \link[smooth]{auto.gum}, \link[smooth]{sma}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
