% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oes.R
\name{oes}
\alias{oes}
\title{Occurrence ETS model}
\usage{
oes(y, model = "MNN", persistence = NULL, initial = "o",
  initialSeason = NULL, phi = NULL, occurrence = c("fixed", "general",
  "odds-ratio", "inverse-odds-ratio", "direct", "auto", "none"),
  ic = c("AICc", "AIC", "BIC", "BICc"), h = 10, holdout = FALSE,
  interval = c("none", "parametric", "likelihood", "semiparametric",
  "nonparametric"), level = 0.95, bounds = c("usual", "admissible",
  "none"), silent = c("all", "graph", "legend", "output", "none"),
  xreg = NULL, xregDo = c("use", "select"), initialX = NULL,
  updateX = FALSE, transitionX = NULL, persistenceX = NULL, ...)
}
\arguments{
\item{y}{Either numeric vector or time series vector.}

\item{model}{The type of ETS model used for the estimation. Normally this should
be \code{"MNN"} or any other pure multiplicative or additive model. The model
selection is available here (although it's not fast), so you can use, for example,
\code{"YYN"} and \code{"XXN"} for selecting between the pure multiplicative and
pure additive models respectively. Using mixed models is possible, but not
recommended.}

\item{persistence}{Persistence vector \eqn{g}, containing smoothing
parameters. If \code{NULL}, then estimated.}

\item{initial}{Can be either character or a vector of initial states. If it
is character, then it can be \code{"optimal"}, meaning that the initial
states are optimised, or \code{"backcasting"}, meaning that the initials are
produced using backcasting procedure.}

\item{initialSeason}{The vector of the initial seasonal components. If \code{NULL},
then it is estimated.}

\item{phi}{The value of the dampening parameter. Used only for damped-trend models.}

\item{occurrence}{The type of model used in probability estimation. Can be
\code{"none"} - none,
\code{"fixed"} - constant probability,
\code{"odds-ratio"} - the Odds-ratio model with b=1 in Beta distribution,
\code{"inverse-odds-ratio"} - the model with a=1 in Beta distribution,
\code{"direct"} - the TSB-like (Teunter et al., 2011) probability update
mechanism a+b=1,
\code{"auto"} - the automatically selected type of occurrence model,
\code{"general"} - the general Beta model with two parameters. This will call
\code{oesg()} function with two similar ETS models and the same provided
parameters (initials and smoothing).}

\item{ic}{The information criteria to use in case of model selection.}

\item{h}{The forecast horizon.}

\item{holdout}{If \code{TRUE}, holdout sample of size \code{h} is taken from
the end of the data.}

\item{interval}{Type of interval to construct. This can be:

\itemize{
\item \code{"none"}, aka \code{"n"} - do not produce prediction
interval.
\item \code{"parametric"}, \code{"p"} - use state-space structure of ETS. In
case of mixed models this is done using simulations, which may take longer
time than for the pure additive and pure multiplicative models. This type
of interval relies on unbiased estimate of in-sample error variance, which
divides the sume of squared errors by T-k rather than just T.
\item \code{"likelihood"}, \code{"l"} - these are the same as \code{"p"}, but
relies on the biased estimate of variance from the likelihood (division by
T, not by T-k).
\item \code{"semiparametric"}, \code{"sp"} - interval based on covariance
matrix of 1 to h steps ahead errors and assumption of normal / log-normal
distribution (depending on error type).
\item \code{"nonparametric"}, \code{"np"} - interval based on values from a
quantile regression on error matrix (see Taylor and Bunn, 1999). The model
used in this process is e[j] = a j^b, where j=1,..,h.
}
The parameter also accepts \code{TRUE} and \code{FALSE}. The former means that
parametric interval are constructed, while the latter is equivalent to
\code{none}.
If the forecasts of the models were combined, then the interval are combined
quantile-wise (Lichtendahl et al., 2013).}

\item{level}{Confidence level. Defines width of prediction interval.}

\item{bounds}{What type of bounds to use in the model estimation. The first
letter can be used instead of the whole word.}

\item{silent}{If \code{silent="none"}, then nothing is silent, everything is
printed out and drawn. \code{silent="all"} means that nothing is produced or
drawn (except for warnings). In case of \code{silent="graph"}, no graph is
produced. If \code{silent="legend"}, then legend of the graph is skipped.
And finally \code{silent="output"} means that nothing is printed out in the
console, but the graph is produced. \code{silent} also accepts \code{TRUE}
and \code{FALSE}. In this case \code{silent=TRUE} is equivalent to
\code{silent="all"}, while \code{silent=FALSE} is equivalent to
\code{silent="none"}. The parameter also accepts first letter of words ("n",
"a", "g", "l", "o").}

\item{xreg}{The vector or the matrix of exogenous variables, explaining some parts
of occurrence variable (probability).}

\item{xregDo}{Variable defines what to do with the provided xreg:
\code{"use"} means that all of the data should be used, while
\code{"select"} means that a selection using \code{ic} should be done.
\code{"combine"} will be available at some point in future...}

\item{initialX}{The vector of initial parameters for exogenous variables.
Ignored if \code{xreg} is NULL.}

\item{updateX}{If \code{TRUE}, transition matrix for exogenous variables is
estimated, introducing non-linear interactions between parameters.
Prerequisite - non-NULL \code{xreg}.}

\item{transitionX}{The transition matrix \eqn{F_x} for exogenous variables. Can
be provided as a vector. Matrix will be formed using the default
\code{matrix(transition,nc,nc)}, where \code{nc} is number of components in
state vector. If \code{NULL}, then estimated. Prerequisite - non-NULL
\code{xreg}.}

\item{persistenceX}{The persistence vector \eqn{g_X}, containing smoothing
parameters for exogenous variables. If \code{NULL}, then estimated.
Prerequisite - non-NULL \code{xreg}.}

\item{...}{The parameters passed to the optimiser, such as \code{maxeval},
\code{xtol_rel}, \code{algorithm} and \code{print_level}. The description of
these is printed out by \code{nloptr.print.options()} function from the \code{nloptr}
package. The default values in the oes function are \code{maxeval=500},
\code{xtol_rel=1E-8}, \code{algorithm="NLOPT_LN_SBPLX"} and \code{print_level=0}.}
}
\value{
The object of class "occurrence" is returned. It contains following list of
values:

\itemize{
\item \code{model} - the type of the estimated ETS model;
\item \code{timeElapsed} - the time elapsed for the construction of the model;
\item \code{fitted} - the fitted values for the probability;
\item \code{fittedModel} - the fitted values of the underlying ETS model, where applicable
(only for occurrence=c("o","i","d"));
\item \code{forecast} - the forecast of the probability for \code{h} observations ahead;
\item \code{forecastModel} - the forecast of the underlying ETS model, where applicable
(only for occurrence=c("o","i","d"));
\item \code{lower} - the lower bound of the interval if \code{interval!="none"};
\item \code{upper} - the upper bound of the interval if \code{interval!="none"};
\item \code{lowerModel} - the lower bound of the interval of the underlying ETS model
if \code{interval!="none"};
\item \code{upperModel} - the upper bound of the interval of the underlying ETS model
if \code{interval!="none"};
\item \code{states} - the values of the state vector;
\item \code{logLik} - the log-likelihood value of the model;
\item \code{nParam} - the number of parameters in the model (the matrix is returned);
\item \code{residuals} - the residuals of the model;
\item \code{y} - actual values of occurrence (zeros and ones).
\item \code{persistence} - the vector of smoothing parameters;
\item \code{phi} - the value of the damped trend parameter;
\item \code{initial} - initial values of the state vector;
\item \code{initialSeason} - the matrix of initials seasonal states;
\item \code{occurrence} - the type of the occurrence model;
\item \code{updateX} - boolean, defining, if the states of exogenous variables were
estimated as well.
\item \code{initialX} - initial values for parameters of exogenous variables.
\item \code{persistenceX} - persistence vector g for exogenous variables.
\item \code{transitionX} - transition matrix F for exogenous variables.
\item \code{accuracy} - The error measures for the forecast (in case of \code{holdout=TRUE}).
\item \code{B} - the vector of all the estimated parameters (in case of "odds-ratio",
"inverse-odds-ratio" and "direct" models).
}
}
\description{
Function returns the occurrence part of iETS model with the specified
probability update and model types.
}
\details{
The function estimates probability of demand occurrence, using the selected
ETS state space models.

For the details about the model and its implementation, see the respective
vignette: \code{vignette("oes","smooth")}
}
\examples{

y <- rpois(100,0.1)
oes(y, occurrence="auto")

oes(y, occurrence="f")

}
\references{
\itemize{
\item Svetunkov Ivan and Boylan John E. (2017). Multiplicative
State-Space Models for Intermittent Time Series. Working Paper of
Department of Management Science, Lancaster University, 2017:4 , 1-43.
\item Teunter R., Syntetos A., Babai Z. (2011). Intermittent demand:
Linking forecasting to inventory obsolescence. European Journal of
Operational Research, 214, 606-615.
\item Croston, J. (1972) Forecasting and stock control for intermittent
demands. Operational Research Quarterly, 23(3), 289-303.
\item Syntetos, A., Boylan J. (2005) The accuracy of intermittent demand
estimates. International Journal of Forecasting, 21(2), 303-314.
}
}
\seealso{
\code{\link[forecast]{ets}, \link[smooth]{oesg}, \link[smooth]{es}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{demand}
\keyword{exponential}
\keyword{forecasting}
\keyword{intermittent}
\keyword{iss}
\keyword{model}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{smoothing}
\keyword{space}
\keyword{state}
\keyword{ts}
\keyword{univar}
