% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msdecompose.R
\name{msdecompose}
\alias{msdecompose}
\title{Multiple seasonal classical decomposition}
\usage{
msdecompose(y, lags = c(12), type = c("additive", "multiplicative"))
}
\arguments{
\item{y}{Vector or ts object, containing data needed to be smoothed.}

\item{lags}{Vector of lags, corresponding to the frequencies in the data.}

\item{type}{The type of decomposition. If \code{"multiplicative"} is selected,
then the logarithm of data is taken prior to the decomposition.}
}
\value{
The object of the class "msdecompose" is return, containing:
\itemize{
\item \code{y} - the original time series.
\item \code{initial} - the estimates of the initial level and trend.
\item \code{trend} - the long term trend in the data.
\item \code{seasonal} - the list of seasonal parameters.
\item \code{lags} - the provided lags.
\item \code{type} - the selected type of the decomposition.
\item \code{yName} - the name of the provided data.
}
}
\description{
Function decomposes multiple seasonal time series into components using
the principles of classical decomposition.
}
\details{
The function applies centred moving averages based on \link[forecast]{ma}
function and order specified in \code{lags} variable in order to smooth the
original series and obtain level, trend and seasonal components of the series.
}
\examples{

# Decomposition of multiple frequency data
\dontrun{ourModel <- msdecompose(forecast::taylor, lags=c(48,336), type="m")}
ourModel <- msdecompose(AirPassengers, lags=c(12), type="m")

plot(ourModel)
plot(forecast(ourModel, model="AAN", h=12))

}
\seealso{
\code{\link[forecast]{ma}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
