% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{objFunction}
\alias{objFunction}
\title{Auxiliary function defining the LASSO objective function.}
\usage{
objFunction(beta, X, y, lambda)
}
\arguments{
\item{beta}{The \eqn{p}-vector of coefficients.}

\item{X}{The data matrix of dimensions \eqn{n \times p}.}

\item{y}{The \eqn{n}-vector of responses.}

\item{lambda}{The LASSO regularization parameter.}
}
\value{
The value of the LASSO objective function.
}
\description{
Auxiliary function defining the LASSO objective function.
}
\examples{
library(smoothedLasso)
n <- 100
p <- 500
beta <- runif(p)
X <- matrix(runif(n*p),nrow=n,ncol=p)
y <- X \%*\% beta
lambda <- 1
print(objFunction(beta,X,y,lambda))

}
