% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confBounds.R
\name{confBounds}
\alias{confBounds}
\title{Asymptotically Unbiased Confidence Bounds}
\usage{
confBounds(
  obj,
  alpha = 0.95,
  p = c(0, 1, 2, 3),
  plot = TRUE,
  showPar = TRUE,
  rescale = TRUE,
  ...
)
}
\arguments{
\item{obj}{an object returned by either \code{\link{msmooth}},
\code{\link{tsmooth}} or \code{\link{dsmooth}}.}

\item{alpha}{the confidence level; a single numeric value between \code{0}
and \code{1}; \code{0.95} is the default.}

\item{p}{the order of polynomial used for the parametric polynomial
regression that is conducted as a benchmark for the trend function;
must satisfy \eqn{0 \leq}{0 \le} \code{p} \eqn{\leq 3}{\le 3}; set to
\code{1} by default; is irrelevant, if a derivative of the trend of order
greater than zero is being analyzed.}

\item{plot}{a logical value; for \code{plot = TRUE}, the default, a plot is
created.}

\item{showPar}{set to \code{TRUE}, if the parametric fitted values are to be
shown against the unbiased estimates and the confidence bounds for
\code{plot = TRUE}; the default is \code{TRUE}.}

\item{rescale}{a single logical value; is set to \code{TRUE} by default;
if the output of a derivative estimation process is passed to \code{obj} and
if \code{rescale = TRUE}, the estimates and confidence bounds will be
rescaled according to \code{x} for the plot (see also the details on the
parameter \emph{...}); the numerical output stays unchanged.}

\item{...}{further arguments that can be passed to the \code{plot} function;
if an argument \code{x} with time points is not given by the user,
\code{x = 1:length(obj$ye)} is used per default for the observation time
points.}
}
\value{
A plot is created in the plot window and a list with different components
is returned.

\describe{
\item{alpha}{a numeric vector of length 1; the level of confidence; input
argument.}
\item{b.ub}{a numeric vector with one element that represents the adjusted
bandwidth for the unbiased trend estimation.}
\item{p.estim}{a numeric vector with the estimates following the parametric
regression defined by \code{p} that is conducted as a benchmark for the trend
function; for the trend's derivatives or for \code{p = 0}, a constant value
is the benchmark; the values are obtained with respect to the rescaled time
points on the interval \eqn{[0, 1]}.}
\item{n}{the number of observations.}
\item{np.estim}{a data frame with the three (numeric) columns \strong{ye.ub},
\strong{lower} and \strong{upper}; in \strong{ye.ub} the unbiased trend
estimates, in \strong{lower} the lower confidence bound and in \strong{upper}
the upper confidence bound can be found; the values are obtained with respect
to the rescaled time points on the interval \eqn{[0, 1]}.}
\item{v}{the order of the trend's derivative considered for the test.}
}
}
\description{
Asymptotically Unbiased Confidence Bounds
}
\details{
This function is part of the \code{smoots} package and was implemented under
version 1.1.0. The underlying theory is based on the additive nonparametric
regression function
\deqn{y_t = m(x_t) + \epsilon_t,}
where \eqn{y_t} is the observed time series, \eqn{x_t} is the rescaled time
on the interval \eqn{[0, 1]}, \eqn{m(x_t)} is a smooth trend function and
\eqn{\epsilon_t} are stationary errors with \eqn{E(\epsilon_t) = 0} and
short-range dependence.

The purpose of this function is the estimation of reasonable confidence
intervals for the nonparametric trend function and its derivatives. The
optimal bandwidth minimizes the Asymptotic Mean Integrated Squared Error
(AMISE) criterion, however, local polynomial estimates are (usually) biased.
The bias is then (approximately)
\deqn{\frac{h^{k - v} m^{(k)}(x) \beta_{(\nu, k)}}{k!},}{h^[k-v]
m^(k)(x)\beta_(\nu,k) / k!,}
where \eqn{p} is the order of the local polynomials, \eqn{k = p + 1} is the
order of the asymptotically equivalent kernel, \eqn{\nu} is the order of the
of the trend function's derivative, \eqn{m^(v)} is the \eqn{\nu}-th order
derivative of the trend function and \eqn{\beta_{(\nu, k)} = \int_{-1}^{1}
u^k K_{(\nu, k)}(u) du}{\beta_(\nu, k) = int_[-1]^[1] u^k K_(\nu, k)(u) du}.
\eqn{K_{(\nu, k)}(u)}{K_(\nu, k)(u)} is the \eqn{k}-th order asymptotically
equivalent kernel function for estimating \eqn{m^{(\nu)}}{m^(\nu)}.
A renewed estimation with an adjusted bandwidth
\eqn{h_{ub} = o(n^{-1 / (2k + 1)})}{h_[ub] = o[n^[-1 / (2k + 1)]]}, i.e., a
bandwidth with a smaller order than the optimal bandwidth, is conducted.
\eqn{h = h_{A}^{(2k + 1) / (2k)}}{h = (h_[A])^[(2k + 1) / (2k)]}, where
\eqn{h_{A}}{h_[A]} is the optimal bandwidth, is implemented.

Following this idea, we have that
\deqn{\sqrt{nh}[m^{(\nu)}(x) - \hat{m}^{(\nu)}(x)]}{(nh)^[1/2] (m^(v)(x) -
hat(m)^(v)(x))}
converges to
\deqn{N(0,2\pi c_f R(x))}
in distribution, where \eqn{2\pi c_f} is the sum of autocovariances.
Consequently, the trend (or derivative) estimates are asymptotically unbiased
and normally distributed.

To make use of this function, an object of class \code{smoots} can be given
as input that was created by either \code{\link{msmooth}},
\code{\link{tsmooth}} or \code{\link{dsmooth}}. Based on the optimal
bandwidth saved within \code{obj}, an adjustment to the bandwidth is made so
that the estimates following the adjusted bandwidth are (relatively)
unbiased.

Based on the input argument \code{alpha}, the level of confidence between
\code{0} and \code{1}, the respective confidence bounds are calculated for
each observation point.

From the input argument \code{obj}, the order of derivative is automatically
obtained. By means of the argument \code{p}, an order of polynomial is
selected for a parametric regression of the trend function. This is only
meaningful, if the trend (and not its derivatives) is analyzed. Otherwise,
the argument is automatically dropped by the function. Furthermore, if
\code{plot = TRUE}, a plot of the unbiased trend (or derivative) estimates
alongside the confidence bounds is created. If also \code{showPar = TRUE},
the estimated parametric trend (or parametric constant value for the
derivatives) is added to the confidence bound plot for comparison.

NOTE:

The values that are returned by the function are obtained with respect to
the rescaled time points on the interval \eqn{[0, 1]}. While the plot can be
adjusted and rescaled by means of a given vector with the actual time points,
the numeric output is not rescaled. For this purpose we refer the user to
the \code{\link{rescale}} function of the \code{smoots} package.

This function implements C++ code by means of the
\code{\link[Rcpp:Rcpp-package]{Rcpp}} and
\code{\link[RcppArmadillo:RcppArmadillo-package]{RcppArmadillo}} packages for
better performance.
}
\examples{
log_gdp <- log(smoots::gdpUS$GDP)
est <- msmooth(log_gdp)
confBounds(est)

}
\references{
Beran, J. and Feng, Y. (2002). Local polynomial fitting with long-memory,
short-memory and antipersistent errors. Annals of the Institute of
Statistical Mathematics, 54(2), 291-311.

Feng, Y., Gries, T. and Fritz, M. (2020). Data-driven
local polynomial for the trend and its derivatives in economic time
series. Journal of Nonparametric Statistics, 32:2, 510-533.

Feng, Y., Gries, T., Letmathe, S. and Schulz, D. (2019). The smoots package
in R for semiparametric modeling of trend stationary time series. Discussion
Paper. Paderborn University. Unpublished.

Feng, Y., Gries, T., Fritz, M., Letmathe, S. and Schulz, D. (2020).
Diagnosing the trend and bootstrapping the forecasting intervals using a
semiparametric ARMA. Discussion Paper. Paderborn University. Unpublished.
}
\author{
\itemize{
\item Yuanhua Feng (Department of Economics, Paderborn University), \cr
Author of the Algorithms \cr
Website: \url{https://wiwi.uni-paderborn.de/en/dep4/feng/}
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Package Creator and Maintainer
}
}
