\name{dmst}
\alias{dmst}
\alias{pmst}
\alias{rmst}
\title{
Multivariate skew-t distribution
}
\description{
Probability density function, distribution function and random number 
generation for the multivariate skew-t (MST) distribution.
}
\usage{
dmst(x, xi=rep(0,d), Omega, alpha, df=Inf)
pmst(x, xi=rep(0,d), Omega, alpha, df=Inf, ...)
rmst(n=1, xi=rep(0,d), Omega, alpha, df=Inf)
}
\arguments{
\item{x}{
for \code{dmsn}, this is either a vector of length \code{d} or a matrix 
with \code{d} columns, where \code{d} is \code{length(alpha)}, giving 
the coordinates of the point(s) where the density must be avaluated;
for \code{pmsn}, only a vector of length \code{d} is allowed.
}
\item{xi}{
a numeric vector of lenght \code{d}, or a matrix with \code{d} columns,
representing the location parameter of the distribution.
If \code{xi} is a matrix, its dimensions must agree with those of \code{x}.
}
\item{Omega}{
a covariance matrix of dimension \code{(d,d)}.
}
\item{alpha}{
a numeric vector which regulates the shape of the density.
}
\item{df}{
degrees of freedom (scalar); default is \code{df=Inf} which corresponds 
to the multivariate skew-normal distribution.
}
\item{n}{
a numeric value which represents the number of random vectors
to be drawn.
}
\item{...}{
additional parameters passed to \code{pmvt}
}}
\value{
A vector of density values (\code{dmst}), or a matrix of random 
points (\code{rmst}).
}
\section{Background}{
The family of multivariate skew-t distributions is an extension of the 
multivariate Student's t family, via the introduction of a \code{shape} 
parameter which regulates skewness; when \code{shape=0}, the skew-t 
distribution reduces to the usual t distribution. 
When \code{df=Inf} the distribution reduces to the multivariate skew-normal 
one; see \code{dmsn}. See the reference below for additional information.
}
\details{
\code{pmst} requires \code{pmvt} from \code{library(mvtnorm)};
the accuracy of its computation can be controlled via use of \code{...}
}
\references{
Azzalini, A. and Capitanio, A. (2002).
  Distributions generated by perturbation of symmetry 
  with emphasis on a multivariate skew \emph{t} distribution.
  Submitted to \emph{J.Roy. Statist. Soc.}
}
\seealso{
\code{\link{dst}}, \code{\link{mst.fit}}, \code{\link{dmsn}},
\code{\link[mvtnorm]{pmvt}}
}
\examples{
x <- seq(-4,4,length=15)
xi <- c(0.5, -1)
Omega <- diag(2)
Omega[2,1] <- Omega[1,2] <- 0.5
alpha <- c(2,2)
pdf <- dmst(cbind(x,2*x-1), xi, Omega, alpha, df=5)
rnd <- rmst(10,  xi, Omega, alpha, 6)
library(mvtnorm)                # only once in the session
cdf <- pmst(c(2,1), xi, Omega, alpha, df=5)

}
\keyword{distribution}
\keyword{multivariate}

