% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cushion.R
\docType{data}
\name{Cushion}
\alias{Cushion}
\title{sofa connection client}
\arguments{
\item{host}{(character) A base URL (without the transport), e.g., \code{localhost},
\code{127.0.0.1}, or \code{foobar.cloudant.com}}

\item{port}{(numeric) Port. Remember that if you don't want a port set, set this
parameter to \code{NULL}. Default: \code{5984}}

\item{path}{(character) context path that is appended to the end of the url. e.g.,
\code{bar} in \code{http://foo.com/bar}. Default: NULL, ignored}

\item{transport}{(character) http or https. Default: http}

\item{user}{(character) A user name}

\item{pwd}{(character) A password}

\item{headers}{Either an object of class \code{request} or a list that can be coerced
to an object of class \code{request} via \code{\link[httr]{add_headers}}. These headers
are used in all requests. To use headers in individual requests and not others, pass
in headers using \code{\link[httr]{add_headers}} via \code{...} in a function call.}
}
\value{
An object of class \code{Cushion}, with variables accessible for
host, port, path, transport, user, pwd, and headers. Functions are callable
to get headers, and to make the base url sent with all requests.
}
\description{
sofa connection client
}
\details{
\strong{Methods}
  \describe{
    \item{\code{ping()}}{
      Ping the CouchDB server
    }
    \item{\code{make_url()}}{
      Construct full base URL from the pieces in the connection object
    }
    \item{\code{get_headers()}}{
      Get headers that will be sent with each request
    }
  }
}
\section{CouchDB versions}{

\pkg{sofa} was built assuming CouchDB version 2 or greater. Some
functionality of this package will work with versions < 2, while
some may not (mango queries, see \code{\link{db_query}}). I don't
plan to support older CouchDB versions per se.
}
\examples{
\dontrun{
# Create a CouchDB connection client
(x <- Cushion$new())

## metadata
x$host
x$path
x$port
x$type

## ping the CouchDB server
x$ping()

## CouchDB server statistics
# stats(x)

# create database
db_create(x, "stuff")

# add documents to a database
db_create(x, "sofadb")
doc1 <- '{"name": "drink", "beer": "IPA", "score": 5}'
doc_create(x, dbname="sofadb", docid="abeer", doc1)

# bulk create
db_create(x, "mymtcars")
bulk_create(x, dbname="mymtcars", doc = mtcars)
db_list(x)

## database info
db_info(x, "bulktest")

## list dbs
db_list(x)

## all docs
alldocs(x, "bulktest", limit = 3)

## changes
changes(x, "bulktest")

# With auth
x <- Cushion$new(user = 'sckott', pwd = 'sckott')

# Using Cloudant
z <- Cushion$new(host = "ropensci.cloudant.com", transport = 'https', port = NULL,
   user = 'ropensci', pwd = Sys.getenv('CLOUDANT_PWD'))
z
db_list(z)
db_create(z, "stuff2")
db_info(z, "stuff2")
alldocs(z, "foobar")
}
}
\keyword{datasets}

