% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxaExtent.R
\name{taxaExtent}
\alias{taxaExtent}
\title{Retrieve Soil Taxonomy Membership Grids}
\usage{
taxaExtent(
  x,
  level = c("order", "suborder", "greatgroup", "subgroup"),
  timeout = 60
)
}
\arguments{
\item{x}{single taxa name, case-insensitive}

\item{level}{the taxonomic level within the top 4 tiers of Soil Taxonomy, one of \code{c('order', 'suborder', 'greatgroup', 'subgroup')}}

\item{timeout}{time that we are willing to wait for a response, in seconds}
}
\value{
a \code{raster} object
}
\description{
This function downloads a generalized representation of the geographic extent of any single taxa from the top 4 tiers of Soil Taxonomy. Data are provided by SoilWeb, ultimately sourced from from the current SSURGO snapshot. Data are returned as \code{raster} objects representing area proportion falling within 800m cells. Data are only available in CONUS and returned using an Albers Equal Area / NAD83 coordinate reference system.
}
\note{
This is a work in progress.
}
\examples{
\donttest{

if(requireNamespace("curl") &
   curl::has_internet()) {
  
  library(raster)
  
  # try a couple of different examples
  
  # soil order
  taxa <- 'vertisols'
  x <- taxaExtent(taxa, level = 'order')
  a <- raster::aggregate(x, fact = 5)
  
  # suborder
  taxa <- 'ustalfs'
  x <- taxaExtent(taxa, level = 'suborder')
  a <- raster::aggregate(x, fact = 5)
  
  # greatgroup
  taxa <- 'haplohumults'
  x <- taxaExtent(taxa, level = 'greatgroup')
  a <- raster::aggregate(x, fact = 5)
  
  # subgroup
  taxa <- 'Typic Haploxerepts'
  x <- taxaExtent(taxa, level = 'subgroup')
  a <- raster::aggregate(x, fact = 5)
  
  # quick evaluation of the result
  if(requireNamespace("rasterVis") & requireNamespace('viridis')) {
    rasterVis::levelplot(a, 
      margin = FALSE, scales = list(draw = FALSE), 
      col.regions = viridis::viridis, 
      main = names(a)
    )
  }
  
  # slippy map
  if(requireNamespace("mapview")) {
    mapview::mapview(a, col.regions = viridis::viridis, na.color = NA, use.layer.names = TRUE)
  }
  
  
  
}

}

}
\author{
D.E. Beaudette
}
