% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_component_data_from_NASIS_db.R
\name{get_comonth_from_NASIS_db}
\alias{get_comonth_from_NASIS_db}
\title{Extract component month data from a local NASIS Database}
\usage{
get_comonth_from_NASIS_db(
  SS = TRUE,
  fill = FALSE,
  stringsAsFactors = default.stringsAsFactors(),
  dsn = NULL
)
}
\arguments{
\item{SS}{get data from the currently loaded Selected Set in NASIS or from
the entire local database (default: TRUE)}

\item{fill}{should missing "month" rows in the comonth table be filled with
NA (FALSE)}

\item{stringsAsFactors}{logical: should character vectors be converted to
factors? This argument is passed to the uncode() function. It does not
convert those vectors that have set outside of uncode() (i.e. hard coded).
The 'factory-fresh' default is TRUE, but this can be changed by setting
options(stringsAsFactors = FALSE)}

\item{dsn}{Optional: path to local SQLite database containing NASIS
table structure; default: \code{NULL}}
}
\value{
A list with the results.
}
\description{
Extract component month data from a local NASIS Database.
}
\details{
This function currently works only on Windows.
}
\examples{

\donttest{
if(local_NASIS_defined()) {
  # query text note data
  cm <- try(get_comonth_from_NASIS_db())

  # show structure of component month data
  str(cm)
}
}

}
\seealso{
\code{\link{fetchNASIS}}
}
\author{
Stephen Roecker
}
\keyword{manip}
