% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_component_from_SDA.R
\name{get_component_from_SDA}
\alias{get_component_from_SDA}
\alias{get_cointerp_from_SDA}
\alias{get_legend_from_SDA}
\alias{get_lmuaoverlap_from_SDA}
\alias{get_mapunit_from_SDA}
\alias{get_chorizon_from_SDA}
\alias{fetchSDA}
\alias{get_cosoilmoist_from_SDA}
\title{Get SSURGO/STATSGO2 Mapunit Data from Soil Data Access}
\usage{
get_component_from_SDA(
  WHERE = NULL,
  duplicates = FALSE,
  childs = TRUE,
  droplevels = TRUE,
  nullFragsAreZero = TRUE,
  stringsAsFactors = NULL
)

get_cointerp_from_SDA(
  WHERE = NULL,
  mrulename = NULL,
  duplicates = FALSE,
  droplevels = TRUE,
  stringsAsFactors = NULL
)

get_legend_from_SDA(WHERE = NULL, droplevels = TRUE, stringsAsFactors = NULL)

get_lmuaoverlap_from_SDA(
  WHERE = NULL,
  droplevels = TRUE,
  stringsAsFactors = NULL
)

get_mapunit_from_SDA(WHERE = NULL, droplevels = TRUE, stringsAsFactors = NULL)

get_chorizon_from_SDA(
  WHERE = NULL,
  duplicates = FALSE,
  childs = TRUE,
  nullFragsAreZero = TRUE,
  droplevels = TRUE,
  stringsAsFactors = NULL
)

fetchSDA(
  WHERE = NULL,
  duplicates = FALSE,
  childs = TRUE,
  nullFragsAreZero = TRUE,
  rmHzErrors = FALSE,
  droplevels = TRUE,
  stringsAsFactors = NULL
)
}
\arguments{
\item{WHERE}{text string formatted as an SQL WHERE clause (default: FALSE)}

\item{duplicates}{logical; if TRUE a record is returned for each unique
mukey (may be many per nationalmusym)}

\item{childs}{logical; if FALSE parent material and geomorphic child tables
are not flattened and appended}

\item{droplevels}{logical: indicating whether to drop unused levels in
classifying factors. This is useful when a class has large number of unused
classes, which can waste space in tables and figures.}

\item{nullFragsAreZero}{should fragment volumes of NULL be interpreted as 0?
(default: TRUE), see details}

\item{stringsAsFactors}{deprecated}

\item{mrulename}{character. Interpretation rule names}

\item{rmHzErrors}{should pedons with horizonation errors be removed from the
results? (default: FALSE)}
}
\value{
A data.frame or SoilProfileCollection object.
}
\description{
Functions to download and flatten commonly used tables and from Soil Data
Access, and create soil profile collection objects (SPC).
}
\details{
These functions return data from Soil Data Access with the use of a simple
text string that formatted as an SQL WHERE clause (e.g. \code{WHERE =
"areasymbol = 'IN001'"}. All functions are SQL queries that wrap around
\code{SDAquery()} and format the data for analysis.

Beware SDA includes the data for both SSURGO and STATSGO2. The
\code{areasymbol} for STATSGO2 is \code{US}. For just SSURGO, include
\code{WHERE = "areareasymbol != 'US'"}.

If the duplicates argument is set to TRUE, duplicate components are
returned. This is not necessary with data returned from NASIS, which has one
unique national map unit. SDA has duplicate map national map units, one for
each legend it exists in.

The value of \code{nullFragsAreZero} will have a significant impact on the
rock fragment fractions returned by \code{fetchSDA}. Set
\code{nullFragsAreZero = FALSE} in those cases where there are many
data-gaps and NULL rock fragment values should be interpreted as NULLs. Set
\code{nullFragsAreZero = TRUE} in those cases where NULL rock fragment
values should be interpreted as 0.

Additional examples can be found in the \href{http://ncss-tech.github.io/AQP/soilDB/SDA-tutorial.html}{Soil Data Access (SDA) Tutorial}
}
\seealso{
\link{SDA_query}
}
\author{
Stephen Roecker
}
\keyword{manip}
