% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_extended_data_from_NASIS_db.R
\name{get_extended_data_from_NASIS_db}
\alias{get_extended_data_from_NASIS_db}
\title{Extract accessory tables and summaries from a local NASIS Database}
\usage{
get_extended_data_from_NASIS_db(
  SS = TRUE,
  nullFragsAreZero = TRUE,
  stringsAsFactors = default.stringsAsFactors(),
  dsn = NULL
)
}
\arguments{
\item{SS}{get data from the currently loaded Selected Set in NASIS or from
the entire local database (default: \code{TRUE})}

\item{nullFragsAreZero}{should fragment volumes of NULL be interpreted as 0?
(default: TRUE), see details}

\item{stringsAsFactors}{logical: should character vectors be converted to
factors? This argument is passed to the \code{uncode()} function. It does not
convert those vectors that have been set outside of \code{uncode()} (i.e. hard
coded).}

\item{dsn}{Optional: path to local SQLite database containing NASIS
table structure; default: \code{NULL}}
}
\value{
A list with the results.
}
\description{
Extract accessory tables and summaries from a local NASIS Database
}
\examples{

\donttest{

if(local_NASIS_defined()) {
 # query extended data
 e <- try(get_extended_data_from_NASIS_db())

 # show contents of extended data
 str(e)
}

}

}
\seealso{
\code{\link{get_hz_data_from_NASIS_db}},
\code{\link{get_site_data_from_NASIS_db}}
}
\author{
Jay M. Skovlin and Dylan E. Beaudette
}
\keyword{manip}
