% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_alcc.R
\name{mod_alcc}
\alias{mod_alcc}
\title{Modified Arcsine-Log Calibration Curve}
\usage{
mod_alcc(
  data = NULL,
  ry,
  stv,
  target,
  confidence = 0.95,
  tidy = FALSE,
  plot = FALSE
)
}
\arguments{
\item{data}{Optional argument to call and object of type data.frame or data.table
containing the stv and ry data, Default: NULL}

\item{ry}{name of the vector containing relative yield values (\%) of type \code{numeric}.}

\item{stv}{name of the vector containing soil test values of type \code{numeric}.}

\item{target}{\code{numeric} value of relative yield target (e.g. 90 for 90\%) to estimate the CSTV.}

\item{confidence}{\code{numeric} value of confidence level (e.g. 0.95 for
significance = 0.05)}

\item{tidy}{logical operator (TRUE/FALSE) to decide the type of return. TRUE returns a data.frame, FALSE returns a list (default).}

\item{plot}{logical operator (TRUE/FALSE) to decide the type of return. TRUE returns a ggplot,
FALSE returns either a list (tidy == FALSE) or a data.frame (tidy == TRUE).}
}
\value{
returns an object of type \code{ggplot} if plot = TRUE.

returns an object of class \code{data.frame} if tidy = TRUE,

returns an object of class \code{list} if tidy = FALSE.
}
\description{
This function runs the modified arcsine-log calibration curve to
estimate critical soil test values (CSTV) following Correndo et al. (2017)
}
\details{
See \href{https://adriancorrendo.github.io/soiltestcorr/articles/mod_alcc_tutorial.html}{online-documentation} for additional details.
}
\note{
For extended reference, we recommend to visit \doi{10.7910/DVN/NABA57} and
\url{https://github.com/adriancorrendo/modified-ALCC} by Adrian Correndo.
}
\examples{
\donttest{
 # Example 1 dataset
 dat <- data.frame("ry" = c(65,80,85,88,90,94,93,96,97,95,98,100,99,99,100),
                   "stv" = c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
 # Run
 fit_example <- mod_alcc(data = dat, ry = ry, stv = stv, target=90, confidence = 0.95)
 fit_example
}
}
\references{
Correndo et al. (2017).
A modification of the arcsine–log calibration curve for analysing soil test value–relative yield relationships.
\emph{Crop and Pasture Science, 68(3), 297-304.} \doi{10.1071/CP16444}
}
\seealso{
\code{\link[rlang]{eval_tidy}},\code{\link[rlang]{defusing-advanced}}
\code{\link[stats]{TDist}},\code{\link[stats]{cor}},\code{\link[stats]{cor.test}},\code{\link[stats]{sd}}
\code{\link[dplyr]{bind}},\code{\link[dplyr]{filter}}
\code{\link[tidyr]{nest}}
\code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{aes}},\code{\link[ggplot2]{geom_point}},\code{\link[ggplot2]{scale_manual}},\code{\link[ggplot2]{geom_rug}},\code{\link[ggplot2]{geom_abline}},\code{\link[ggplot2]{geom_path}},\code{\link[ggplot2]{annotate}},\code{\link[ggplot2]{labs}},\code{\link[ggplot2]{theme}}
\code{\link[ggpp]{annotate}}
}
