.onAttach <- function(# Internal. Message displayed when loading the package.
 libname, 
 pkgname  
){  
    #cat( "'", pkgname, "' loaded.\n" ) 
    
    # Setup the polish triangle and language setting
    ## if( !(tolower(Sys.info()["sysname"]) %in% c("mac","darwin")) ) 
    
    if( tolower(Sys.info()["sysname"]) %in% c("windows") ){ # "linux",
        try( source( system.file( "polish_triangle.r", 
            package = pkgname ), encoding = "UTF-8" ) )
        tryRes <- try( source( system.file( "polish_language.r", 
            package = pkgname ), encoding = "UTF-8" ) ) 
        
    }else{ 
        try( source( system.file( "polish_triangle_ANSI.r", 
            package = pkgname ) ) )
        tryRes <- try( source( system.file( "polish_language_ANSI.r", 
            package = pkgname ) ) ) 
    }   
    
    
    #   Extend language parameter if the polish triangle was loaded
    #   successfully
    if( !("try-error" %in% class( tryRes )) ){ 
        lang.par <- TT.get( "lang.par" ) 
        
        lang.par <- rbind( 
            lang.par, 
            lang.par2 
        )   
        
        TT.set( "lang.par" = lang.par ) 
    }else{ 
        packageStartupMessage( "soiltexture: The polish triangle could not be loaded" )
    }   
    
    
    # Welcome message
    if( interactive() ){ 
        msg <- sprintf( 
            "%s %s  For help type: help(pack='%s')", 
            pkgname, 
            as.character( packageVersion( pkgname ) ), 
            pkgname ) 
        
        packageStartupMessage( msg ) 
    }   
    
}   

