% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_clusterprop.R
\name{collection_clusterprop}
\alias{collection_clusterprop}
\title{Add, edit, delete a cluster-wide property}
\usage{
collection_clusterprop(name, val, raw = FALSE, callopts = list())
}
\arguments{
\item{name}{(character) Required. The name of the property. The two supported
properties names are urlScheme and autoAddReplicas. Other names are rejected
with an error}

\item{val}{(character) Required. The value of the property. If the value is
empty or null, the property is unset.}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{callopts}{curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Important: whether add, edit, or delete is used is determined by
the value passed to the \code{val} parameter. If the property name is
new, it will be added. If the property name exists, and the value is different,
it will be edited. If the property name exists, and the value is NULL or empty
the property is deleted (unset).
}
\examples{
\dontrun{
solr_connect()

# add the value https to the property urlScheme
collection_clusterprop(name = "urlScheme", val = "https")

# status again
collection_clusterstatus()$cluster$properties

# delete the property urlScheme by setting val to NULL or a 0 length string
collection_clusterprop(name = "urlScheme", val = "")
}
}

