\name{FDdata}
\alias{FDdata}
\docType{data}
\title{
half diallel data for corn hybrids
}
\description{
This dataset contains phenotpic data for 36 winter bean hybrids, coming from a full diallel design and evaluated for 9 traits. The column male and female origin columns are included as well. 

}
\usage{data("FDdata")}
\format{
  The format is:
 chr "FDdata"
}
\source{
This data was generated by a winter bean study and originally included in the agridat package.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

}
\examples{
####=========================================####
#### For CRAN time limitations most lines in the 
#### examples are silenced with one '#' mark, 
#### remove them and run the examples
####=========================================####
data(FDdata)
head(FDdata)
mix <- mmer2(stems~1, random=~female+male, data=FDdata)
summary(mix)

####=========================================####
####=========================================####
#### using mmer function would be like
####=========================================####
####=========================================####
Z1 <- model.matrix(~female-1, data=FDdata)
Z2 <- model.matrix(~male-1, data=FDdata)
ETA <- list(GCA1=list(Z=Z1), GCA2=list(Z=Z2))
y <- FDdata$stems
mix2 <- mmer(Y=y, Z=ETA, method = "NR")
summary(mix2)


####=========================================####
####=========================================####
#### Multivariate model example
####=========================================####
####=========================================####

# data(FDdata)
# head(FDdata)
# 
# mix <- mmer2(cbind(stems,pods,seeds)~1, 
#              random=~female+male, MVM=TRUE,data=FDdata)
# summary(mix)
# #### genetic variance covariance
# gvc <- mix$var.comp$female
# #### extract variances (diagonals) and get standard deviations 
# sd.gvc <- as.matrix(sqrt(diag(gvc)))
# #### get possible products sd(Vgi) * sd(Vgi')
# prod.sd <- sd.gvc %*% t(sd.gvc)
# #### genetic correlations cov(gi,gi')/[sd(Vgi) * sd(Vgi')] 
# (gen.cor <- gvc/prod.sd)
# #### pods and seeds have a strong negative genetic covariance (-.79)
# #### more pods, less seeds

}
\keyword{datasets}
\seealso{The core function of the package \code{\link{mmer}}}
