% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{vec2df.hist}
\alias{vec2df.hist}
\title{A vector to data frame converter for \code{\link{fitTable}}. This one makes a histogram, and returns a data frame with midpoints and counts.}
\usage{
vec2df.hist(data)
}
\arguments{
\item{data}{[numeric vector] The data to be converted.}
}
\value{
[data.frame] Converted \code{data}.
}
\description{
A vector to data frame converter for \code{\link{fitTable}}. This one makes a histogram, and returns a data frame with midpoints and counts.
}
\examples{
dataset <- summary (sampleSoundCorrsData.abc)
models <- list (
	"model A" = list (
		formula = "Y ~ a/X",
		start = list (list(a=1))),
	"model B" = list (
		formula = "Y ~ a/(1+exp(1)^X)",
		start = list (list(a=1)))
)
fitTable (models, dataset, 1, vec2df.hist)
}
