% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{transcription}
\alias{transcription}
\title{Constructor function for the \code{transcription} class.}
\usage{
transcription(
  data,
  col.grapheme = "GRAPHEME",
  col.meta = "META",
  col.value = "VALUE"
)
}
\arguments{
\item{data}{[data.frame] Data frame containing the transcription and its meaning.}

\item{col.grapheme}{[character] Name of the column with graphemes. Defaults to \code{"GRAPHEME"}.}

\item{col.meta}{[character] Name of the column with the coverage of metacharacters. If empty string or \code{NA}, the column will be generated automatically. Defaults to \code{"META"}.}

\item{col.value}{[character] Name of the column with values of graphemes. Defaults to \code{"VALUE"}.}
}
\value{
[transcription] A \code{transcription} object containing the provided data.
}
\description{
Take a data frame containing transcription and turn it into a \code{transcription} object, as required by the \code{\link{soundcorrs}} constructor function. In the normal workflow, the user should have no need to call this function other than through \code{\link{read.transcription}}.
}
\section{Fields}{

\describe{
\item{\code{data}}{[data.frame] The original data frame.}

\item{\code{cols}}{[character list] Names of the important columns in the data frame.}

\item{\code{zero}}{[character] A regular expression to catch linguistic zeros.}
}}

\examples{
# path to a sample transcription
fName <- system.file ("extdata", "trans-common.tsv", package="soundcorrs")
fut <- transcription (read.table(fName,header=TRUE))
}
