% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrogram.R
\name{spectrogram}
\alias{spectrogram}
\title{Spectrogram}
\usage{
spectrogram(x, samplingRate = NULL, windowLength = 50, step = NULL,
  overlap = 70, wn = "gaussian", zp = 0, smoothFreq = 0,
  smoothTime = 0, qTime = 0, percentNoise = 10, noiseReduction = 0,
  contrast = 0.2, brightness = 0, method = c("spectrum",
  "spectralDerivative")[1], output = c("none", "original", "processed")[1],
  ylim = NULL, plot = TRUE, osc = FALSE, colorTheme = c("bw", "seewave",
  "...")[1], xlab = "Time, ms", ylab = "Frequency, KHz", main = "",
  frameBank = NULL, duration = NULL, ...)
}
\arguments{
\item{x}{path to a .wav file or a vector of amplitudes with specified
samplingRate}

\item{samplingRate}{sampling rate of \code{x} (only needed if
\code{x} is a numeric vector, rather than a .wav file)}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{overlap}{overlap between successive FFT frames, \%}

\item{wn}{window type: gaussian, hanning, hamming, bartlett, rectangular,
blackman, flattop}

\item{zp}{window length after zero padding, points}

\item{smoothFreq, smoothTime}{length of the window, in data points (0 to
+inf), for calculating a rolling median. Applies median smoothing to
spectrogram in frequency and time domains, respectively}

\item{qTime}{the quantile to be subtracted for each frequency
bin. For ex., if qTime = 0.5, the median of each frequency
bin (over the entire sound duration) will be calculated and subtracted from
each frame (see examples)}

\item{percentNoise}{percentage of frames (0 to 100\%) used for calculating noise
spectrum}

\item{noiseReduction}{how much noise to remove (0 to +inf, recommended 0 to
2). 0 = no noise reduction, 2 = strong noise reduction: \eqn{spectrum -
(noiseReduction * noiseSpectrum)}, where noiseSpectrum is the average
spectrum of frames with entropy exceeding the quantile set by
\code{percentNoise}}

\item{contrast}{spectrum is exponentiated by contrast (-inf to +inf,
recommended -1 to +1). Contrast >0 increases sharpness, <0 decreases
sharpness}

\item{brightness}{how much to "lighten" the image (>0 = lighter, <0 = darker)}

\item{method}{plot spectrum ('spectrum') or spectral derivative
('spectralDerivative')}

\item{output}{specifies what to return: nothing ('none'), unmodified
spectrogram ('original'), or denoised and/or smoothed spectrogram
('processed')}

\item{ylim}{frequency range to plot, kHz (defaults to 0 to Nyquist frequency)}

\item{plot}{should a spectrogram be plotted? TRUE / FALSE}

\item{osc}{should an oscillogram be shown under the spectrogram? TRUE / FALSE}

\item{colorTheme}{black and white ('bw'), as in seewave package ('seewave'),
or any palette from \code{\link[grDevices]{palette}} such as
'heat.colors', 'cm.colors', etc}

\item{xlab, ylab, main}{graphical parameters}

\item{frameBank}{ignore (only needed for pitch tracking)}

\item{duration}{ignore (only needed for pitch tracking)}

\item{...}{other graphical parameters passed to
\code{seewave:::filled.contour.modif2}}
}
\value{
Returns nothing (if output = 'none'), raw spectrum (if output =
  'original'), denoised and/or smoothed spectrum (if output = 'processed'),
  or spectral derivatives (if method = 'spectralDerivative') as a matrix of
  real numbers.
}
\description{
Produces the spectrogram of a sound using short-term Fourier transform. This
is a simplified version of \code{\link[seewave]{spectro}} with fewer plotting
options, but with added routines for noise reduction, smoothing in time and
frequency domains, and controlling contrast and brightness.
}
\examples{
# synthesize a sound 1 s long, with gradually increasing hissing noise
sound = soundgen(sylLen = 1000, temperature = 0.001, noiseAnchors = list(
  time = c(0, 1300), value = c(-120, 0)), formantsNoise = list(
  f1 = list(freq = 5000, width = 10000)))
# playme(sound, samplingRate = 16000)

# basic spectrogram
spectrogram(sound, samplingRate = 16000)

\dontrun{
# add an oscillogram
spectrogram(sound, samplingRate = 16000, osc = TRUE)
# broad-band instead of narrow-band
spectrogram(sound, samplingRate = 16000, windowLength = 5)

# focus only on values in the upper 5\% of power for each frequency bin
spectrogram(sound, samplingRate = 16000, qTime = 0.95)

# detect 10\% of the noisiest frames based on entropy and remove the pattern
# found in those frames (in this cases, breathing)
spectrogram(sound, samplingRate = 16000,  noiseReduction = 1.1,
  brightness = -2)  # white noise gone

# apply median smoothing in both time and frequency domains
spectrogram(sound, samplingRate = 16000, smoothFreq = 5,
  smoothTime = 5)

# increase contrast, reduce brightness
spectrogram(sound, samplingRate = 16000, contrast = 1, brightness = -1)

# add bells and whistles
spectrogram(sound, samplingRate = 16000, osc = TRUE, noiseReduction = 1.1,
  brightness = -1, colorTheme = 'heat.colors',
  ylim = c(0,5), cex.lab = .75, main = 'My spectrogram')
}
}
