% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSM.R
\name{selfsim}
\alias{selfsim}
\title{Compute self-similarity}
\usage{
selfsim(
  m,
  norm = FALSE,
  simil = c("cosine", "cor")[1],
  win = 1,
  sparse = FALSE,
  kernelSize = NULL
)
}
\arguments{
\item{m}{input matrix such as a spectrogram}

\item{norm}{if TRUE, the spectrum of each STFT frame is normalized}

\item{simil}{method for comparing frames: "cosine" = cosine similarity, "cor"
= Pearson's correlation}

\item{win}{the length of window for averaging self-similarity, frames}

\item{sparse}{if TRUE, the entire SSM is not calculated, but only the central
region needed to extract the novelty contour (speeds up the processing)}
}
\value{
Returns a square self-similarity matrix.
}
\description{
Internal soundgen function.
}
\details{
Called by \code{\link{ssm}}.
}
\examples{
m = matrix(rnorm(40), nrow = 5)
soundgen:::selfsim(m, sparse = TRUE, kernelSize = 2)
}
\keyword{internal}
