% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{processAudio}
\alias{processAudio}
\title{Process audio}
\usage{
processAudio(
  x,
  samplingRate = NULL,
  scale = NULL,
  from = NULL,
  to = NULL,
  funToCall,
  myPars = list(),
  var_noSummary = NULL,
  reportEvery = NULL,
  savePlots = NULL,
  saveAudio = NULL,
  cores = 1
)
}
\arguments{
\item{x}{path to a folder, one or more wav or mp3 files c('file1.wav',
'file2.mp3'), Wave object, numeric vector, or a list of Wave objects or
numeric vectors}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{scale}{maximum possible amplitude of input used for normalization of
input vector (only needed if \code{x} is a numeric vector)}

\item{from}{if NULL (default), analyzes the whole sound, otherwise
from...to (s)}

\item{to}{if NULL (default), analyzes the whole sound, otherwise
from...to (s)}

\item{funToCall}{function to call (specify what to do with each audio input)}

\item{myPars}{a list of parameters to pass on to `funToCall`}

\item{var_noSummary}{names of output variables that should not be summarized}

\item{reportEvery}{when processing multiple inputs, report estimated time
left every ... iterations (NULL = default, NA = don't report)}

\item{savePlots}{full path to the folder in which to save the plots (NULL =
don't save, '' = same folder as audio)}

\item{cores}{number of cores for parallel processing}

\item{summaryFun}{function(s) used to summarize the output per input}
}
\description{
Internal soundgen function.
}
\examples{
\dontrun{
# How many cores should I use? Maybe ~4
a1 = analyze('~/Downloads/temp60/', cores = 1)  # 3:55
a2 = analyze('~/Downloads/temp60/', cores = 2, reportEvery = 100)  # 2:30
a3 = analyze('~/Downloads/temp60/', cores = 3, reportEvery = 100)  # 1:50
a4 = analyze('~/Downloads/temp60/', cores = 4, reportEvery = 100)  # 1:33
a7 = analyze('~/Downloads/temp60/', cores = 7, reportEvery = 100)  # 1:29
}
}
\keyword{internal}
