% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prosody.R
\name{prosody}
\alias{prosody}
\title{Prosody}
\usage{
prosody(
  x,
  samplingRate = NULL,
  multProsody,
  analyze_pars = list(),
  shiftPitch_pars = list(),
  pitchManual = NULL,
  play = FALSE,
  saveAudio = NULL,
  reportEvery = NULL,
  cores = 1,
  plot = FALSE,
  savePlots = NULL,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{x}{path to a folder, one or more wav or mp3 files c('file1.wav',
'file2.mp3'), Wave object, numeric vector, or a list of Wave objects or
numeric vectors}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{multProsody}{multiplier of pitch excursion from median (on a
logarithmic or musical scale): >1 = exaggerate intonation, 1 = no change, <1
= flatten, 0 = completely flat at the original median pitch}

\item{analyze_pars}{a list of parameters to pass to \code{\link{analyze}}
(only needed if \code{pitchManual} is NULL - that is, if we attempt to
track pitch automatically)}

\item{shiftPitch_pars}{a list of parameters to pass to
\code{\link{shiftPitch}} to fine-tune the pitch-shifting algorithm}

\item{pitchManual}{manually corrected pitch contour. For a single sound,
provide a numeric vector of any length. For multiple sounds, provide a
dataframe with columns "file" and "pitch" (or path to a csv file) as
returned by \code{\link{pitch_app}}, ideally with the same windowLength and
step as in current call to analyze. A named list with pitch vectors per
file is also OK}

\item{play}{if TRUE, plays the processed audio}

\item{saveAudio}{full (!) path to folder for saving the processed audio; NULL
= don't save, '' = same as input folder (NB: overwrites the originals!)}

\item{reportEvery}{when processing multiple inputs, report estimated time
left every ... iterations (NULL = default, NA = don't report)}

\item{cores}{number of cores for parallel processing}

\item{plot}{should a spectrogram be plotted? TRUE / FALSE}

\item{savePlots}{full path to the folder in which to save the plots (NULL =
don't save, '' = same folder as audio)}

\item{width}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{height}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{units}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{...}{other graphical parameters}
}
\value{
If the input is a single audio (file, Wave, or numeric vector),
  returns the processed waveform as a numeric vector with the original
  sampling rate and scale. If the input is a folder with several audio files,
  returns a list of processed waveforms, one for each file.
}
\description{
Exaggerates or flattens the intonation by performing a dynamic pitch shift,
changing pitch excursion from its original median value without changing the
formants. This is a particular case of pitch shifting, which is performed
with \code{\link{shiftPitch}}. The result is likely to be improved if
manually corrected pitch contours are provided. Depending on the nature of
audio, the settings that control pitch shifting may also need to be
fine-tuned with the \code{shiftPitch_pars} argument.
}
\examples{
s = soundgen(sylLen = 200, pitch = c(150, 220), addSilence = 20,
             plot = TRUE, yScale = 'log')
# playme(s)
s1 = prosody(s, 16000, multProsody = 2,
  analyze_pars = list(windowLength = 25, step = 5),
  shiftPitch_pars = list(windowLength = 20, step = 5, freqWindow = 300),
  plot = TRUE)
# playme(s1)
# spectrogram(s1, 16000, yScale = 'log')

\dontrun{
# Flat intonation - remove all frequency modulation
s2 = prosody(s, 16000, multProsody = 0,
  analyze_pars = list(windowLength = 25, step = 5),
  shiftPitch_pars = list(windowLength = 20, step = 5, freqWindow = 300),
  plot = TRUE)
playme(s2)
spectrogram(s2, 16000, yScale = 'log')

# Download an example - a bit of speech (sampled at 16000 Hz)
download.file('http://cogsci.se/soundgen/audio/speechEx.wav',
              destfile = '~/Downloads/temp1/speechEx.wav')
target = '~/Downloads/temp1/speechEx.wav'
samplingRate = tuneR::readWave(target)@samp.rate
spectrogram(target, yScale = 'log')
playme(target)

s3 = prosody(target, multProsody = 1.5, shiftPitch_pars = list(
  freqWindow = 400, propagation = 'adaptive'))
spectrogram(s3, tuneR::readWave(target)@samp.rate, yScale = 'log')
playme(s3)

# process all audio files in a folder
s4 = prosody('~/Downloads/temp', multProsody = 2, savePlots = '',
             saveAudio = '~/Downloads/temp/prosody')
str(s4)  # returns a list with audio (+ saves it to disk)
}
}
\seealso{
\code{\link{shiftPitch}}
}
