% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrogram.R
\name{.spectrogram}
\alias{.spectrogram}
\title{Spectrogram per sound}
\usage{
.spectrogram(
  audio,
  dynamicRange = 80,
  windowLength = 50,
  step = windowLength/2,
  overlap = NULL,
  specType = c("spectrum", "reassigned", "spectralDerivative")[1],
  rasterize = FALSE,
  wn = "gaussian",
  zp = 0,
  normalize = TRUE,
  smoothFreq = 0,
  smoothTime = 0,
  qTime = 0,
  percentNoise = 10,
  noiseReduction = 0,
  output = c("original", "processed", "complex", "all")[1],
  plot = TRUE,
  osc = c("none", "linear", "dB")[2],
  heights = c(3, 1),
  ylim = NULL,
  yScale = "linear",
  contrast = 0.2,
  brightness = 0,
  blur = 0,
  maxPoints = c(1e+05, 5e+05),
  padWithSilence = TRUE,
  colorTheme = c("bw", "seewave", "heat.colors", "...")[1],
  col = NULL,
  extraContour = NULL,
  xlab = NULL,
  ylab = NULL,
  xaxp = NULL,
  mar = c(5.1, 4.1, 4.1, 2),
  main = NULL,
  grid = NULL,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  internal = NULL,
  ...
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{dynamicRange}{dynamic range, dB. All values more than one dynamicRange
under maximum are treated as zero}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms (NB:
because digital audio is sampled at discrete time intervals of
1/samplingRate, the actual step and thus the time stamps of STFT frames
may be slightly different, eg 24.98866 instead of 25.0 ms)}

\item{overlap}{overlap between successive FFT frames, \%}

\item{specType}{plot the original FFT ('spectrum'), reassigned spectrogram
('reassigned'), or spectral derivative ('spectralDerivative')}

\item{rasterize}{(only applies if specType = 'reassigned') if TRUE, the
reassigned spectrogram is plotted after rasterizing it: that is, showing
density per time-frequency bins with the same resolution as an ordinary
spectrogram}

\item{wn}{window type accepted by \code{\link[seewave]{ftwindow}}, currently
gaussian, hanning, hamming, bartlett, rectangular, blackman, flattop}

\item{zp}{window length after zero padding, points}

\item{normalize}{if TRUE, scales input prior to FFT}

\item{smoothFreq, smoothTime}{length of the window for median smoothing in
frequency and time domains, respectively, points}

\item{qTime}{the quantile to be subtracted for each frequency bin. For ex.,
if qTime = 0.5, the median of each frequency bin (over the entire sound
duration) will be calculated and subtracted from each frame (see examples)}

\item{percentNoise}{percentage of frames (0 to 100\%) used for calculating
noise spectrum}

\item{noiseReduction}{how much noise to remove (non-negative number,
recommended 0 to 2). 0 = no noise reduction, 2 = strong noise reduction:
\eqn{spectrum - (noiseReduction * noiseSpectrum)}, where noiseSpectrum is
the average spectrum of frames with entropy exceeding the quantile set by
\code{percentNoise}}

\item{output}{specifies what to return: nothing ('none'), unmodified
spectrogram ('original'), denoised and/or smoothed spectrogram
('processed'), or unmodified spectrogram with the imaginary part giving
phase ('complex')}

\item{plot}{should a spectrogram be plotted? TRUE / FALSE}

\item{osc}{"none" = no oscillogram; "linear" = on the original scale; "dB" =
in decibels}

\item{heights}{a vector of length two specifying the relative height of the
spectrogram and the oscillogram (including time axes labels)}

\item{ylim}{frequency range to plot, kHz (defaults to 0 to Nyquist
frequency). NB: still in kHz, even if yScale = bark, mel, or ERB}

\item{yScale}{scale of the frequency axis: 'linear' = linear, 'log' =
logarithmic (musical), 'bark' = bark with \code{\link[tuneR]{hz2bark}},
'mel' = mel with \code{\link[tuneR]{hz2mel}}, 'ERB' = Equivalent
Rectangular Bandwidths with \code{\link{HzToERB}}}

\item{contrast}{spectrum is exponentiated by contrast (any real number,
recommended -1 to +1). Contrast >0 increases sharpness, <0 decreases
sharpness}

\item{brightness}{how much to "lighten" the image (>0 = lighter, <0 = darker)}

\item{blur}{apply a Gaussian filter to blur or sharpen the image, two
numbers: frequency (Hz), time (ms). A single number is interpreted as
frequency, and a square filter is applied. NA / NULL / 0 means no blurring
in that dimension. Negative numbers mean un-blurring (sharpening) the image
by dividing instead of multiplying by the filter during convolution}

\item{maxPoints}{the maximum number of "pixels" in the oscillogram (if any)
and spectrogram; good for quickly plotting long audio files; defaults to
c(1e5, 5e5)}

\item{padWithSilence}{if TRUE, pads the sound with just enough silence to
resolve the edges properly (only the original region is plotted, so the
apparent duration doesn't change)}

\item{colorTheme}{black and white ('bw'), as in seewave package ('seewave'),
or any palette from \code{\link[grDevices]{palette}} such as 'heat.colors',
'cm.colors', etc}

\item{col}{actual colors, eg rev(rainbow(100)) - see ?hcl.colors for colors
in base R (overrides colorTheme)}

\item{extraContour}{a vector of arbitrary length scaled in Hz (regardless of
yScale!) that will be plotted over the spectrogram (eg pitch contour); can
also be a list with extra graphical parameters such as lwd, col, etc. (see
examples)}

\item{xlab, ylab, main, mar, xaxp}{graphical parameters for plotting}

\item{grid}{if numeric, adds n = \code{grid} dotted lines per kHz}

\item{width, height, units, res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{internal}{a long list of stuff for plotting pitch contours passed by
analyze()}

\item{...}{other graphical parameters}
}
\description{
Internal soundgen function called by \code{\link{spectrogram}} and
\code{\link{analyze}}.
}
\keyword{internal}
