% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrogram.R
\name{plotUnrasterized}
\alias{plotUnrasterized}
\title{Plot unrasterized spetrogram}
\usage{
plotUnrasterized(
  df,
  xlim = range(df$time, finite = TRUE),
  ylim = range(df$freq, finite = TRUE),
  zlim = range(df$magn, finite = TRUE),
  levels = seq(min(df$magn, na.rm = TRUE), max(df$magn, na.rm = TRUE), length.out =
    nlevels + 1),
  nlevels = 30,
  pch = 16,
  cex = 0.25,
  color.palette = function(n) grDevices::hcl.colors(n, "YlOrRd", rev = TRUE),
  col = color.palette(nlevels),
  legend = FALSE,
  asp = NA,
  xaxs = "i",
  yaxs = "i",
  las = 1,
  log = "",
  yScale = c("orig", "bark", "mel", "ERB")[1],
  axisX = TRUE,
  axisY = TRUE,
  maxPoints = 5e+05,
  ...
)
}
\arguments{
\item{df}{data to plot}

\item{xlim, ylim, zlim}{range of values}

\item{levels, nlevels, pch, cex, color.palette, col, legend, asp, xaxs, yaxs, las, log, axisX, axisY}{graphical parameters passed to plot()}

\item{yScale}{scale of frequency representation}

\item{maxPoints}{downsample if too big for plotting}
}
\description{
Internal soundgen function
}
\details{
Helper function for adding a customized frequency axis to the spectrogram
}
\keyword{internal}
