% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sox.R
\name{plot.sox}
\alias{plot.sox}
\title{Solution path plot for \code{sox()}}
\usage{
\method{plot}{sox}(x, type = "l", log = "x", ...)
}
\arguments{
\item{x}{Fitted \code{\link{sox}} model.}

\item{type}{Graphical argument to be passed to \code{\link{matplot}()}, a character string (length 1 vector) or vector of 1-character strings indicating the type of plot for each column of y, see \link{plot.default} for all possible types. Default is "l" for lines.}

\item{log}{Graphical argument to be passed to \code{\link{matplot}()}, a character string which contains "x" if the x axis is to be logarithmic, "y" if the y axis is to be logarithmic, "" if neither, "xy" or "yx" if both axes are to be logarithmic. Default is "x".}

\item{...}{Further arguments of \code{\link{matplot}()} and ultimately of \code{\link{plot.default}()} for some.}
}
\value{
Produces a coefficient profile plot of the coefficient paths for a fitted \code{\link{sox}} model.
}
\description{
Plot the solution path generated by \code{\link{sox}()}.
}
\examples{
x <- as.matrix(sim[, c("A1","A2","C1","C2","B","A1B","A2B","C1B","C2B")])
lam.seq <- exp(seq(log(1e0), log(1e-3), length.out = 20))

overlapping.groups <- list(c(1, 2, 6, 7),
                           c(5, 6, 7, 8, 9),
                           c(6, 7),
                           c(3, 4, 8, 9),
                           c(8, 9))
                           
pars.overlapping <- overlap_structure(overlapping.groups)

fit.overlapping <- sox(
  x = x,
  ID = sim$Id,
  time = sim$Start,
  time2 = sim$Stop,
  event = sim$Event,
  penalty = "overlapping",
  lambda = lam.seq,
  group = pars.overlapping$groups,
  group_variable = pars.overlapping$groups_var,
  penalty_weights = pars.overlapping$group_weights,
  tol = 1e-4,
  maxit = 1e3,
  verbose = FALSE
)

plot(fit.overlapping)
              
cv.overlapping <- sox_cv(
  x = x,
  ID = sim$Id,
  time = sim$Start,
  time2 = sim$Stop,
  event = sim$Event,
  penalty = "overlapping",
  lambda = lam.seq,
  group = pars.overlapping$groups,
  group_variable = pars.overlapping$groups_var,
  penalty_weights = pars.overlapping$group_weights,
  nfolds = 5,
  tol = 1e-4,
  maxit = 1e3,
  verbose = FALSE
)

plot(cv.overlapping$sox.fit)
          
}
\seealso{
\code{\link{sox}}, \code{\link{sox_cv}}.
}
