#spinar_est_param <- function(x, p, type, distr)
test_that("input", {
  ######################## x ########################
  expect_error(spinar_est_param(x = c(1), p = 1, type = "mom", distr = "nb"), "Assertion on 'x' failed: Must have length >= 2, but has length 1.")
  expect_error(spinar_est_param(x = c(1, 0), p = 2, type = "mom",  distr = "nb"), "Assertion on 'x' failed: Must have length >= 3, but has length 2.")
  expect_error(spinar_est_param(x = c(2, 3), p = 2, type = "mom",  distr = "nb"), "Assertion on 'x' failed: Must have length >= 3, but has length 2.")
  expect_error(spinar_est_param(x = c(-1, 2, 0, 4, 5), p = 1, type = "ml",  distr = "poi"), "Assertion on 'x' failed: Element 1 is not >= 0.")
  expect_error(spinar_est_param(x = c(-1, 2, 0, 4, 5), p = 2, type = "ml",  distr = "geo"), "Assertion on 'x' failed: Element 1 is not >= 0.")
  expect_error(spinar_est_param(x = c(1, 2.4, 0, 4, 5), p = 1, type = "ml",  distr = "poi"), "Assertion on 'x' failed: Must be of type 'integerish', but element 2 is not close to an integer.")
  expect_error(spinar_est_param(x = c(1, 2, 0, 4.1, 5), p = 2, type = "ml",  distr = "nb"), "Assertion on 'x' failed: Must be of type 'integerish', but element 4 is not close to an integer.")
  ######################## p ########################
  expect_error(spinar_est_param(x = c(2, 3, 1, 1, 0), p = "1", type = "mom",  distr = "nb"), "Assertion on 'p' failed: Must be of type 'integerish', not 'character'.")
  expect_error(spinar_est_param(x = c(2, 3, 1, 1, 0), type = "mom",  distr = "nb"), 'argument "p" is missing, with no default')
  expect_error(spinar_est_param(x = c(2, 3, 1, 1, 0), p = 1.5, type = "mom",  distr = "nb"), "Assertion on 'p' failed: Must be of type 'integerish', but element 1 is not close to an integer.")
  expect_error(spinar_est_param(x = c(2, 3, 1, 1, 0), p = 0.5, type = "mom",  distr = "nb"), "Assertion on 'p' failed: Must be of type 'integerish', but element 1 is not close to an integer.")
  expect_error(spinar_est_param(x = c(2, 3, 1, 1, 0), p = -3, type = "mom",  distr = "nb"), "Assertion on 'p' failed: Element 1 is not >= 1.")
  expect_error(spinar_est_param(x = c(2, 3, 1, 1, 0), p = c(2,1), type = "mom",  distr = "nb"), "Assertion on 'p' failed")
  ######################## type ########################
  expect_error(spinar_est_param(x = rpois(10, 2), p = 1, type = "mon",  distr = "nb"))
  expect_error(spinar_est_param(x = rpois(10, 3), p = 1, type = 2,  distr = "nb"))
  expect_error(spinar_est_param(x = rpois(10, 4), p = 1, type = "MOM",  distr = "nb"))
  expect_error(spinar_est_param(x = rpois(10, 2), p = 2, type = "mam",  distr = "nb"))
  expect_error(spinar_est_param(x = rpois(10, 2), p = 2, type = 2,  distr = "nb"))
  expect_error(spinar_est_param(x = rpois(10, 2), p = 2, type = mom,  distr = "nb"))
  ######################## distr ########################
  expect_error(spinar_est_param(x = rpois(10, 2), p = 1, type = "ml",  distr = poi), "object 'poi' not found")
  expect_error(spinar_est_param(x = rpois(10, 2), p = 1, type = "ml",  distr = "POI"))
  expect_error(spinar_est_param(x = rpois(10, 2), p = 1, type = "ml",  distr = 2))
  expect_error(spinar_est_param(x = rpois(10, 2), p = 2, type = "ml",  distr = poi))
  expect_error(spinar_est_param(x = rpois(10, 2), p = 2, type = "ml",  distr = "POI"))
  expect_error(spinar_est_param(x = rpois(10, 2), p = 2, type = "ml",  distr = 2))
})

test_that("output size", {
  ######################## size ########################
  expect_equal(length(spinar_est_param(x = c(2, 3, 1, 1, 0), p = 1, type="mom", distr = "geo")), 2)
  expect_equal(length(spinar_est_param(x = c(1, 1, 1, 0), p = 1, type="ml",distr = "geo")), 2)
  expect_equal(length(spinar_est_param(x=c(1, 3, 1, 1, 2, 2, 1, 2, 1, 4, 2, 2, 5, 5, 3, 2, 3, 3, 3, 3, 3, 2, 1, 2, 2, 4, 6, 5, 4, 8, 5, 8, 8, 10, 11), p=2, type="mom",distr = "poi")), 3)
  ######################## values ########################
  data <- c(1, 1, 1, 1, 1)
  tmp0 <- spinar_est_param(x = data, p = 1, type = "mom", distr = "poi")
  tmp6 <- spinar_est_param(x = data, p = 1, type = "ml", distr = "poi")
  expect_true(tmp0[['alpha1']] ==1)
  expect_true(tmp0[['lambda']] == 0)
  expect_true(tmp6[['alpha1']] == 1)
  expect_true(tmp6[['lambda']] == 0)
  tmp1 <- spinar_est_param(x = data, p = 2, type = "mom", distr = "poi")
  tmp7 <- spinar_est_param(x = data, p = 2, type = "ml", distr = "poi")
  expect_true(tmp1[['alpha1']] == 1)
  expect_true(tmp1[['alpha2']] == 0)
  expect_true(tmp1[['lambda']] == 0)
  expect_true(tmp7[['alpha1']] == 1)
  expect_true(tmp7[['alpha2']] == 0)
  expect_true(tmp7[['lambda']] == 0)
  tmp2 <- spinar_est_param(x = data, p = 1, type = "mom", distr = "geo")
  tmp8 <- spinar_est_param(x = data, p = 1, type = "ml", distr = "geo")
  expect_true(tmp2[['alpha1']] == 1)
  expect_true(tmp2[['prob']] == 1)
  expect_true(tmp8[['alpha1']] == 1)
  expect_true(tmp8[['prob']] == 1)
  tmp3 <- spinar_est_param(x = data, p = 2, type = "mom", distr = "geo")
  tmp9 <- spinar_est_param(x = data, p = 2, type = "ml", distr = "geo")
  expect_true(tmp3[['alpha1']] == 1)
  expect_true(tmp3[['alpha2']] == 0)
  expect_true(tmp3[['prob']] == 1)
  expect_true(tmp9[['alpha1']] == 1)
  expect_true(tmp9[['alpha2']] == 0)
  expect_true(tmp9[['prob']] == 1)
  tmp4 <- spinar_est_param(x = data, p = 1, type = "mom", distr = "nb")
  tmp10 <- spinar_est_param(x = data, p = 1, type = "ml", distr = "nb")
  expect_true(tmp4[['alpha1']] == 1)
  expect_true(tmp4[['r']] == 1)
  expect_true(tmp4[['prob']] == 1)
  expect_true(tmp10[['alpha1']] == 1)
  expect_true(tmp10[['r']] == 1)
  expect_true(tmp10[['prob']] == 1)
  tmp5 <- spinar_est_param(x = data, p = 2, type = "mom", distr = "nb")
  tmp11 <- spinar_est_param(x = data, p = 2, type = "ml", distr = "nb")
  expect_true(tmp5[['alpha1']] == 1)
  expect_true(tmp5[['alpha2']] == 0)
  expect_true(tmp5[['r']] == 1)
  expect_true(tmp5[['prob']] == 1)
  expect_true(tmp11[['alpha1']] == 1)
  expect_true(tmp11[['alpha2']] == 0)
  expect_true(tmp11[['r']] == 1)
  expect_true(tmp11[['prob']] == 1)

  sample <- sample(1:10, 5, replace = FALSE)
  TMP0 <- spinar_est_param(x = sample, p = 1, type = "mom", distr = "poi")
  TMP6 <- spinar_est_param(x = sample, p = 1, type = "ml", distr = "poi")
  expect_true(TMP0[['alpha1']] < 1)
  expect_true(TMP0[['lambda']] > 0)
  expect_true(TMP6[['alpha1']] < 1)
  expect_true(TMP6[['lambda']] > 0)
  TMP1 <- spinar_est_param(x = sample, p = 2, type = "mom", distr = "poi")
  TMP7 <- spinar_est_param(x = sample, p = 2, type = "ml", distr = "poi")
  expect_true(TMP1[['alpha1']] < 1)
  expect_true(TMP1[['alpha2']] > 0)
  expect_true(TMP1[['lambda']] > 0)
  expect_true(TMP7[['alpha1']] < 1)
  expect_true(TMP7[['alpha2']] > 0)
  expect_true(TMP7[['lambda']] > 0)
  TMP2 <- spinar_est_param(x = sample, p = 1, type = "mom", distr = "geo")
  TMP8 <- spinar_est_param(x = sample, p = 1, type = "ml", distr = "geo")
  expect_true(TMP2[['alpha1']] < 1)
  expect_true(TMP2[['prob']] < 1)
  expect_true(TMP8[['alpha1']] < 1)
  expect_true(TMP8[['prob']] < 1)
  TMP3 <- spinar_est_param(x = sample, p = 2, type = "mom", distr = "geo")
  TMP9 <- spinar_est_param(x = sample, p = 2, type = "ml", distr = "geo")
  expect_true(TMP3[['alpha1']] < 1)
  expect_true(TMP3[['alpha2']] > 0)
  expect_true(TMP3[['prob']] < 1)
  expect_true(TMP9[['alpha1']] < 1)
  expect_true(TMP9[['alpha2']] > 0)
  expect_true(TMP9[['prob']] < 1)
  TMP4 <- spinar_est_param(x = sample, p = 1, type = "mom", distr = "nb")
  TMP10 <- spinar_est_param(x = sample, p = 1, type = "ml", distr = "nb")
  expect_true(TMP4[['alpha1']] < 1)
  expect_true(TMP4[['r']] > 0)
  expect_true(TMP4[['prob']] < 1)
  expect_true(TMP10[['alpha1']] < 1)
  expect_true(TMP10[['r']] > 0)
  expect_true(TMP10[['prob']] < 1)
  TMP5 <- spinar_est_param(x = sample, p = 2, type = "mom", distr = "nb")
  TMP11 <- spinar_est_param(x = sample, p = 2, type = "ml", distr = "nb")
  expect_true(TMP5[['alpha1']] < 1)
  expect_true(TMP5[['alpha2']] > 0)
  expect_true(TMP5[['r']] > 0)
  expect_true(TMP5[['prob']] < 1)
  expect_true(TMP11[['alpha1']] < 1)
  expect_true(TMP11[['alpha2']] > 0)
  expect_true(TMP11[['r']] >0)
  expect_true(TMP11[['prob']] < 1)
  ######################## type ########################
  expect_type(spinar_est_param(x = c(2, 0, 1,3,4,5), p = 1, type="ml", distr = "nb"), "double")
  expect_type(spinar_est_param(x = c(2, 0, 1,4,7,9, 1), p = 1, type="ml", distr = "nb")[1], "double")
  })
