% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nkde_execution_functions.R
\name{nkde_worker}
\alias{nkde_worker}
\title{NKDE worker}
\usage{
nkde_worker(
  lines,
  events,
  samples,
  kernel_name,
  bw,
  bws,
  method,
  div,
  digits,
  tol,
  sparse,
  max_depth,
  verbose = FALSE
)
}
\arguments{
\item{lines}{A SpatialLinesDataFrame with the sampling points. The
geometries must be a SpatialLinesDataFrame (may crash if some geometries
 are invalid)}

\item{events}{A SpatialPointsDataFrame representing the events on the
network. The points will be snapped on the network.}

\item{samples}{A SpatialPointsDataFrame representing the locations for
which the densities will be estimated.}

\item{kernel_name}{The name of the kernel to use}

\item{bw}{The global kernel bandwidth}

\item{bws}{The kernel bandwidth (in meters) for each event}

\item{method}{The method to use when calculating the NKDE, must be one of
simple / discontinuous / continuous (see details for more information)}

\item{div}{The divisor to use for the kernel. Must be "n" (the number of
events within the radius around each sampling point), "bw" (the bandwidth)
"none" (the simple sum).}

\item{digits}{The number of digits to keep in the spatial coordinates. It
ensures that topology is good when building the network. Default is 3}

\item{tol}{When adding the events and the sampling points to the network,
the minimum distance between these points and the lines extremities. When
points are closer, they are added at the extremity of the lines.}

\item{sparse}{A Boolean indicating if sparse or regular matrices should be
used by the Rcpp functions. Regular matrices are faster, but require more
memory and could lead to error, in particular with multiprocessing. Sparse
matrices are slower, but require much less memory.}

\item{max_depth}{When using the continuous and discontinuous methods, the
calculation time and memory use can go wild  if the network has a lot of
small edges (area with a lot of intersections and a lot of events). To
avoid it, it is possible to set here a maximum depth. Considering that the
kernel is divided at intersections, a value of 8 should yield good
estimates. A larger value can be used without problem for the discontinuous
method. For the continuous method, a larger value will strongly impact
calculation speed.}

\item{verbose}{A Boolean, indicating if the function should print messages
about the process.}
}
\value{
A numeric vector with the nkde values
}
\description{
The worker function for nkde and nkde.mc
}
\examples{
#This is an internal function, no example provided
}
\keyword{internal}
