% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PointSim.R
\name{PointSim}
\alias{PointSim}
\title{Simulate a spatial point process or sequence}
\usage{
PointSim(points, window, type, seed)
}
\arguments{
\item{points}{the number of points to simulate}

\item{window}{a spacejamr object to use as the spatial extent}

\item{type}{the type of simulation. poisson_process simulates a spatial
Poisson process. halton simulates a Halton sequence where the maximal number
of simulated points is the first argument.}

\item{seed}{an optional seed}
}
\value{
An object of class PointSim that contains a geographical window
of class 'owin'. Within this window are four objects. n: the number of
simulated points. x: the x coordinates of the simulated points. y: the y
coordinates of the simulated points. markformat: an empty place holder.
}
\description{
Creates a new Poisson Point Process in a spacejamr object
}
\examples{
# Load spacejamr object
data("RI")

# Poisson process
ri_points <- PointSim(points = 10, window = RI, seed = 42)

}
\author{
Darren Colby \cr
Email: dscolby17@gmail.com
}
