% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_utils.R
\name{spark_dataframe.ts_rdd}
\alias{spark_dataframe.ts_rdd}
\title{Retrieve a Spark DataFrame}
\usage{
\method{spark_dataframe}{ts_rdd}(x, ...)
}
\arguments{
\item{x}{An R object wrapping, or containing, a Spark DataFrame.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Retrieve a Spark DataFrame from a TimeSeriesRDD object
}
\examples{

library(sparklyr)
library(sparklyr.flint)

sc <- try_spark_connect(master = "local")

if (!is.null(sc)) {
  sdf <- copy_to(sc, tibble::tibble(t = seq(10), v = seq(10)))
  ts <- from_sdf(sdf, is_sorted = TRUE, time_unit = "SECONDS", time_column = "t")
  print(ts \%>\% spark_dataframe())
  print(sdf \%>\% spark_dataframe()) # the former should contain the same set of
                                   # rows as the latter does, modulo possible
                                   # difference in types of timestamp columns
} else {
  message("Unable to establish a Spark connection!")
}

}
\seealso{
Other Spark dataframe utility functions: 
\code{\link{collect.ts_rdd}()},
\code{\link{from_rdd}()},
\code{\link{from_sdf}()},
\code{\link{spark_connection.ts_rdd}()},
\code{\link{spark_jobj.ts_rdd}()},
\code{\link{to_sdf}()},
\code{\link{ts_rdd_builder}()}
}
\concept{Spark dataframe utility functions}
