% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spark_connection.R
\name{spark-api}
\alias{hive_context}
\alias{java_context}
\alias{spark-api}
\alias{spark_context}
\alias{spark_session}
\title{Access the Spark API}
\usage{
spark_context(sc)

java_context(sc)

hive_context(sc)

spark_session(sc)
}
\arguments{
\item{sc}{A \code{spark_connection}.}
}
\description{
Access the commonly-used Spark objects associated with a Spark instance.
These objects provide access to different facets of the Spark API.
}
\details{
The \href{http://spark.apache.org/docs/latest/api/scala/#package}{Scala API documentation}
is useful for discovering what methods are available for each of these
objects. Use \code{\link{invoke}} to call methods on these objects.
}
\section{Spark Context}{


The main entry point for Spark functionality. The \strong{Spark Context}
represents the connection to a Spark cluster, and can be used to create
\code{RDD}s, accumulators and broadcast variables on that cluster.
}

\section{Java Spark Context}{


A Java-friendly version of the aforementioned \strong{Spark Context}.
}

\section{Hive Context}{


An instance of the Spark SQL execution engine that integrates with data
stored in Hive. Configuration for Hive is read from \code{hive-site.xml} on
the classpath.

Starting with Spark >= 2.0.0, the \strong{Hive Context} class has been
deprecated -- it is superceded by the \strong{Spark Session} class, and
\code{hive_context} will return a \strong{Spark Session} object instead.
Note that both classes share a SQL interface, and therefore one can invoke
SQL through these objects.
}

\section{Spark Session}{


Available since Spark 2.0.0, the \strong{Spark Session} unifies the
\strong{Spark Context} and \strong{Hive Context} classes into a single
interface. Its use is recommended over the older APIs for code
targeting Spark 2.0.0 and above.
}

