% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_data.R
\name{stream_write_console}
\alias{stream_write_console}
\title{Write Console Stream}
\usage{
stream_write_console(x, mode = c("append", "complete", "update"),
  options = list(), trigger = stream_trigger_interval(), ...)
}
\arguments{
\item{x}{A Spark DataFrame or dplyr operation}

\item{mode}{Specifies how data is written to a streaming sink. Valid values are
\code{"append"}, \code{"complete"} or \code{"update"}.}

\item{options}{A list of strings with additional options.}

\item{trigger}{The trigger for the stream query, defaults to micro-batches runnnig
every 5 seconds. See \code{\link{stream_trigger_interval}} and
\code{\link{stream_trigger_continuous}}.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Writes a Spark dataframe stream into console logs.
}
\examples{
\dontrun{

sc <- spark_connect(master = "local")

sdf_len(sc, 10) \%>\% dplyr::transmute(text = as.character(id)) \%>\% spark_write_text("text-in")

stream <- stream_read_text(sc, "text-in") \%>\% stream_write_console()

stream_stop(stream)

}

}
\seealso{
Other Spark stream serialization: \code{\link{stream_read_csv}},
  \code{\link{stream_read_delta}},
  \code{\link{stream_read_json}},
  \code{\link{stream_read_kafka}},
  \code{\link{stream_read_orc}},
  \code{\link{stream_read_parquet}},
  \code{\link{stream_read_socket}},
  \code{\link{stream_read_text}},
  \code{\link{stream_write_csv}},
  \code{\link{stream_write_delta}},
  \code{\link{stream_write_json}},
  \code{\link{stream_write_kafka}},
  \code{\link{stream_write_memory}},
  \code{\link{stream_write_orc}},
  \code{\link{stream_write_parquet}},
  \code{\link{stream_write_text}}
}
\concept{Spark stream serialization}
