/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import sparklyr.WeightedQuantileSummaries;

public final class WeightedQuantileSummaries$
implements Serializable {
    public static final WeightedQuantileSummaries$ MODULE$;
    private final int defaultCompressThreshold;
    private final int defaultBufferSize;
    private final double defaultRelativeError;

    static {
        new WeightedQuantileSummaries$();
    }

    public int defaultCompressThreshold() {
        return this.defaultCompressThreshold;
    }

    public int defaultBufferSize() {
        return this.defaultBufferSize;
    }

    public double defaultRelativeError() {
        return this.defaultRelativeError;
    }

    public WeightedQuantileSummaries.Stats[] sparklyr$WeightedQuantileSummaries$$compressImmut(WeightedQuantileSummaries.Stats[] currentSamples, double totalWeight, double mergeThreshold) {
        int i;
        if (currentSamples.length < 3) {
            return currentSamples;
        }
        ListBuffer res = (ListBuffer)ListBuffer$.MODULE$.empty();
        WeightedQuantileSummaries.Stats head = (WeightedQuantileSummaries.Stats)Predef$.MODULE$.refArrayOps((Object[])currentSamples).last();
        Predef$ predef$ = Predef$.MODULE$;
        double leftSum = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(0, i - 1).map((Function1)new Serializable(currentSamples){
            public static final long serialVersionUID = 0L;
            private final WeightedQuantileSummaries.Stats[] currentSamples$1;

            public final double apply(int j) {
                return this.apply$mcDI$sp(j);
            }

            public double apply$mcDI$sp(int j) {
                return this.currentSamples$1[j].s() + this.currentSamples$1[j].l();
            }
            {
                this.currentSamples$1 = currentSamples$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) + currentSamples[i - 1].l();
        double rightSum = head.r();
        double leftIncrement = 0.0;
        double rightIncrement = 0.0;
        double headRightSum = rightSum;
        for (i = currentSamples.length - 2; i >= 1; --i) {
            double gap = totalWeight - headRightSum - leftSum;
            leftSum -= currentSamples[i - 1].l();
            if (i > 1) {
                leftSum -= currentSamples[i - 2].s();
            }
            rightSum += currentSamples[i + 1].s() + currentSamples[i].r();
            if (gap >= mergeThreshold) {
                double x$11 = head.l() + leftIncrement;
                double x$12 = head.copy$default$1();
                double x$13 = head.copy$default$2();
                double x$14 = head.copy$default$4();
                head = head.copy(x$12, x$13, x$11, x$14);
                WeightedQuantileSummaries.Stats qual$4 = currentSamples[i];
                double x$15 = currentSamples[i].r() + rightIncrement;
                double x$16 = qual$4.copy$default$1();
                double x$17 = qual$4.copy$default$2();
                double x$18 = qual$4.copy$default$3();
                currentSamples[i] = qual$4.copy(x$16, x$17, x$18, x$15);
                res.prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WeightedQuantileSummaries.Stats[]{head}));
                head = currentSamples[i];
                headRightSum = rightSum;
                leftIncrement = 0.0;
                rightIncrement = 0.0;
                continue;
            }
            leftIncrement += currentSamples[i].l() + currentSamples[i].s();
            rightIncrement += currentSamples[i].r() + currentSamples[i].s();
        }
        res.prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WeightedQuantileSummaries.Stats[]{head}));
        if (currentSamples.length > 1) {
            res.prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WeightedQuantileSummaries.Stats[]{(WeightedQuantileSummaries.Stats)Predef$.MODULE$.refArrayOps((Object[])currentSamples).head()}));
        }
        return (WeightedQuantileSummaries.Stats[])res.toArray(ClassTag$.MODULE$.apply(WeightedQuantileSummaries.Stats.class));
    }

    public double[][] approxWeightedQuantile(DataFrame df, String[] cols, String weightCol, double[] probabilities, double relativeError) {
        boolean bl = relativeError >= 0.0;
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Relative Error must be non-negative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)relativeError)}))).toString());
        }
        Object[] objectArray = cols;
        Predef$ predef$2 = Predef$.MODULE$;
        Object[] objectArray2 = new String[]{weightCol};
        Predef$ predef$3 = Predef$.MODULE$;
        String[] requiredCols = (String[])new ArrayOps.ofRef(objectArray).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(objectArray2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Object[] objectArray3 = requiredCols;
        Predef$ predef$4 = Predef$.MODULE$;
        Seq colExprs = (Seq)new ArrayOps.ofRef(objectArray3).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String colName) {
                return new Column(colName).cast((DataType)DoubleType$.MODULE$);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        WeightedQuantileSummaries[] emptySummaries = (WeightedQuantileSummaries[])Array$.MODULE$.fill(Predef$.MODULE$.refArrayOps((Object[])cols).size(), (Function0)new Serializable(relativeError){
            public static final long serialVersionUID = 0L;
            private final double relativeError$1;

            public final WeightedQuantileSummaries apply() {
                return new WeightedQuantileSummaries(WeightedQuantileSummaries$.MODULE$.defaultCompressThreshold(), this.relativeError$1, WeightedQuantileSummaries$.MODULE$.$lessinit$greater$default$3(), WeightedQuantileSummaries$.MODULE$.$lessinit$greater$default$4(), WeightedQuantileSummaries$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.relativeError$1 = relativeError$1;
            }
        }, ClassTag$.MODULE$.apply(WeightedQuantileSummaries.class));
        RDD qual$5 = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredCols).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String colName) {
                return functions$.MODULE$.col(colName);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).select(colExprs).rdd();
        Serializable x$20 = new Serializable(weightCol){
            public static final long serialVersionUID = 0L;
            private final String weightCol$1;

            public final WeightedQuantileSummaries[] apply(WeightedQuantileSummaries[] summaries, Row row) {
                return WeightedQuantileSummaries$.MODULE$.sparklyr$WeightedQuantileSummaries$$apply$1(summaries, row, this.weightCol$1);
            }
            {
                this.weightCol$1 = weightCol$1;
            }
        };
        Serializable x$21 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WeightedQuantileSummaries[] apply(WeightedQuantileSummaries[] sum1, WeightedQuantileSummaries[] sum2) {
                return WeightedQuantileSummaries$.MODULE$.sparklyr$WeightedQuantileSummaries$$merge$1(sum1, sum2);
            }
        };
        int x$22 = qual$5.treeAggregate$default$4((Object)emptySummaries);
        WeightedQuantileSummaries[] summaries = (WeightedQuantileSummaries[])qual$5.treeAggregate((Object)emptySummaries, (Function2)x$20, (Function2)x$21, x$22, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(WeightedQuantileSummaries.class)));
        return (double[][])Predef$.MODULE$.refArrayOps((Object[])summaries).map((Function1)new Serializable(probabilities){
            public static final long serialVersionUID = 0L;
            private final double[] probabilities$1;

            public final double[] apply(WeightedQuantileSummaries summary) {
                return (double[])Predef$.MODULE$.doubleArrayOps(this.probabilities$1).flatMap((Function1)new Serializable(this, summary){
                    public static final long serialVersionUID = 0L;
                    private final WeightedQuantileSummaries summary$1;

                    public final Iterable<Object> apply(double quantile) {
                        return Option$.MODULE$.option2Iterable(this.summary$1.query(quantile));
                    }
                    {
                        this.summary$1 = summary$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            }
            {
                this.probabilities$1 = probabilities$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    public WeightedQuantileSummaries.Stats[] $lessinit$greater$default$3() {
        return (WeightedQuantileSummaries.Stats[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(WeightedQuantileSummaries.Stats.class));
    }

    public double $lessinit$greater$default$4() {
        return 0.0;
    }

    public boolean $lessinit$greater$default$5() {
        return false;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final WeightedQuantileSummaries[] sparklyr$WeightedQuantileSummaries$$apply$1(WeightedQuantileSummaries[] summaries, Row row, String weightCol$1) {
        for (int i = 0; i < summaries.length; ++i) {
            double v;
            if (row.isNullAt(i) || Predef$.MODULE$.double2Double(v = row.getDouble(i)).isNaN()) continue;
            double w = row.getDouble(row.fieldIndex(weightCol$1));
            summaries[i] = summaries[i].insert(v, w);
        }
        return summaries;
    }

    public final WeightedQuantileSummaries[] sparklyr$WeightedQuantileSummaries$$merge$1(WeightedQuantileSummaries[] sum1, WeightedQuantileSummaries[] sum2) {
        return (WeightedQuantileSummaries[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sum1).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sum2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WeightedQuantileSummaries apply(Tuple2<WeightedQuantileSummaries, WeightedQuantileSummaries> x0$1) {
                if (x0$1 != null) {
                    return ((WeightedQuantileSummaries)x0$1._1()).compress().merge(((WeightedQuantileSummaries)x0$1._2()).compress());
                }
                throw new MatchError(x0$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WeightedQuantileSummaries.class)));
    }

    private WeightedQuantileSummaries$() {
        MODULE$ = this;
        this.defaultCompressThreshold = 10000;
        this.defaultBufferSize = 50000;
        this.defaultRelativeError = 0.01;
    }
}

