% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_hof.R
\name{hof_aggregate}
\alias{hof_aggregate}
\title{Apply Aggregate Function to Array Column}
\usage{
hof_aggregate(
  x,
  start,
  merge,
  finish = NULL,
  expr = NULL,
  dest_col = NULL,
  ...
)
}
\arguments{
\item{x}{The Spark data frame to run aggregation on}

\item{start}{The starting value of the aggregation}

\item{merge}{The aggregation function}

\item{finish}{Optional param specifying a transformation to apply on the final value of the aggregation}

\item{expr}{The array being aggregated, could be any SQL expression evaluating to an array
(default: the last column of the Spark data frame)}

\item{dest_col}{Column to store the aggregated result (default: expr)}

\item{...}{Additional params to dplyr::mutate}
}
\description{
Apply an element-wise aggregation function to an array column
(this is essentially a dplyr wrapper for the
\code{aggregate(array<T>, A, function<A, T, A>[, function<A, R>]): R}
built-in Spark SQL functions)
}
\examples{
\dontrun{

library(sparklyr)
sc <- spark_connect(master = "local")
# concatenates all numbers of each array in `array_column` and add parentheses
# around the resulting string
copy_to(sc, tibble::tibble(array_column = list(1:5, 21:25))) \%>\%
  hof_aggregate(
    start = "",
    merge = ~ CONCAT(.y, .x),
    finish = ~ CONCAT("(", .x, ")")
  )
}

}
