% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_stat.R
\name{sdf_rhyper}
\alias{sdf_rhyper}
\title{Generate random samples from a hypergeometric distribution}
\usage{
sdf_rhyper(
  sc,
  nn,
  m,
  n,
  k,
  num_partitions = NULL,
  seed = NULL,
  output_col = "x"
)
}
\arguments{
\item{sc}{A Spark connection.}

\item{nn}{Sample Size.}

\item{m}{The number of successes among the population.}

\item{n}{The number of failures among the population.}

\item{k}{The number of draws.}

\item{num_partitions}{Number of partitions in the resulting Spark dataframe
(default: default parallelism of the Spark cluster).}

\item{seed}{Random seed (default: a random long integer).}

\item{output_col}{Name of the output column containing sample values (default: "x").}
}
\description{
Generator method for creating a single-column Spark dataframes comprised of
i.i.d. samples from a hypergeometric distribution.
}
\seealso{
Other Spark statistical routines: 
\code{\link{sdf_rbeta}()},
\code{\link{sdf_rbinom}()},
\code{\link{sdf_rcauchy}()},
\code{\link{sdf_rchisq}()},
\code{\link{sdf_rexp}()},
\code{\link{sdf_rgamma}()},
\code{\link{sdf_rgeom}()},
\code{\link{sdf_rlnorm}()},
\code{\link{sdf_rnorm}()},
\code{\link{sdf_rpois}()},
\code{\link{sdf_rt}()},
\code{\link{sdf_runif}()},
\code{\link{sdf_rweibull}()}
}
\concept{Spark statistical routines}
