% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_classification_decision_tree_classifier.R,
%   R/ml_model_decision_tree.R, R/ml_regression_decision_tree_regressor.R
\name{ml_decision_tree_classifier}
\alias{ml_decision_tree_classifier}
\alias{ml_decision_tree}
\alias{ml_decision_tree_regressor}
\title{Spark ML -- Decision Trees}
\usage{
ml_decision_tree_classifier(
  x,
  formula = NULL,
  max_depth = 5,
  max_bins = 32,
  min_instances_per_node = 1,
  min_info_gain = 0,
  impurity = "gini",
  seed = NULL,
  thresholds = NULL,
  cache_node_ids = FALSE,
  checkpoint_interval = 10,
  max_memory_in_mb = 256,
  features_col = "features",
  label_col = "label",
  prediction_col = "prediction",
  probability_col = "probability",
  raw_prediction_col = "rawPrediction",
  uid = random_string("decision_tree_classifier_"),
  ...
)

ml_decision_tree(
  x,
  formula = NULL,
  type = c("auto", "regression", "classification"),
  features_col = "features",
  label_col = "label",
  prediction_col = "prediction",
  variance_col = NULL,
  probability_col = "probability",
  raw_prediction_col = "rawPrediction",
  checkpoint_interval = 10L,
  impurity = "auto",
  max_bins = 32L,
  max_depth = 5L,
  min_info_gain = 0,
  min_instances_per_node = 1L,
  seed = NULL,
  thresholds = NULL,
  cache_node_ids = FALSE,
  max_memory_in_mb = 256L,
  uid = random_string("decision_tree_"),
  response = NULL,
  features = NULL,
  ...
)

ml_decision_tree_regressor(
  x,
  formula = NULL,
  max_depth = 5,
  max_bins = 32,
  min_instances_per_node = 1,
  min_info_gain = 0,
  impurity = "variance",
  seed = NULL,
  cache_node_ids = FALSE,
  checkpoint_interval = 10,
  max_memory_in_mb = 256,
  variance_col = NULL,
  features_col = "features",
  label_col = "label",
  prediction_col = "prediction",
  uid = random_string("decision_tree_regressor_"),
  ...
)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{formula}{Used when \code{x} is a \code{tbl_spark}. R formula as a character string or a formula. This is used to transform the input dataframe before fitting, see \link{ft_r_formula} for details.}

\item{max_depth}{Maximum depth of the tree (>= 0); that is, the maximum
number of nodes separating any leaves from the root of the tree.}

\item{max_bins}{The maximum number of bins used for discretizing
continuous features and for choosing how to split on features at
each node. More bins give higher granularity.}

\item{min_instances_per_node}{Minimum number of instances each child must
have after split.}

\item{min_info_gain}{Minimum information gain for a split to be considered
at a tree node. Should be >= 0, defaults to 0.}

\item{impurity}{Criterion used for information gain calculation. Supported: "entropy"
and "gini" (default) for classification and "variance" (default) for regression. For
\code{ml_decision_tree}, setting \code{"auto"} will default to the appropriate
criterion based on model type.}

\item{seed}{Seed for random numbers.}

\item{thresholds}{Thresholds in multi-class classification to adjust the probability of predicting each class. Array must have length equal to the number of classes, with values > 0 excepting that at most one value may be 0. The class with largest value \code{p/t} is predicted, where \code{p} is the original probability of that class and \code{t} is the class's threshold.}

\item{cache_node_ids}{If \code{FALSE}, the algorithm will pass trees to
executors to match instances with nodes. If \code{TRUE}, the algorithm will
cache node IDs for each instance. Caching can speed up training of deeper
trees. Defaults to \code{FALSE}.}

\item{checkpoint_interval}{Set checkpoint interval (>= 1) or disable
checkpoint (-1). E.g. 10 means that the cache will get checkpointed every 10
iterations, defaults to 10.}

\item{max_memory_in_mb}{Maximum memory in MB allocated to histogram aggregation.
If too small, then 1 node will be split per iteration, and its aggregates
may exceed this size. Defaults to 256.}

\item{features_col}{Features column name, as a length-one character vector. The column should be single vector column of numeric values. Usually this column is output by \code{\link{ft_r_formula}}.}

\item{label_col}{Label column name. The column should be a numeric column. Usually this column is output by \code{\link{ft_r_formula}}.}

\item{prediction_col}{Prediction column name.}

\item{probability_col}{Column name for predicted class conditional probabilities.}

\item{raw_prediction_col}{Raw prediction (a.k.a. confidence) column name.}

\item{uid}{A character string used to uniquely identify the ML estimator.}

\item{...}{Optional arguments; see Details.}

\item{type}{The type of model to fit. \code{"regression"} treats the response
as a continuous variable, while \code{"classification"} treats the response
as a categorical variable. When \code{"auto"} is used, the model type is
inferred based on the response variable type -- if it is a numeric type,
then regression is used; classification otherwise.}

\item{variance_col}{(Optional) Column name for the biased sample variance of prediction.}

\item{response}{(Deprecated) The name of the response column (as a length-one character vector.)}

\item{features}{(Deprecated) The name of features (terms) to use for the model fit.}
}
\value{
The object returned depends on the class of \code{x}. If it is a
\code{spark_connection}, the function returns a \code{ml_estimator} object. If
it is a \code{ml_pipeline}, it will return a pipeline with the predictor
appended to it. If a \code{tbl_spark}, it will return a \code{tbl_spark} with
the predictions added to it.
}
\description{
Perform classification and regression using decision trees.
}
\details{
\code{ml_decision_tree} is a wrapper around \code{ml_decision_tree_regressor.tbl_spark} and \code{ml_decision_tree_classifier.tbl_spark} and calls the appropriate method based on model type.
}
\examples{
\dontrun{
sc <- spark_connect(master = "local")
iris_tbl <- sdf_copy_to(sc, iris, name = "iris_tbl", overwrite = TRUE)

partitions <- iris_tbl \%>\%
  sdf_random_split(training = 0.7, test = 0.3, seed = 1111)

iris_training <- partitions$training
iris_test <- partitions$test

dt_model <- iris_training \%>\%
  ml_decision_tree(Species ~ .)

pred <- ml_predict(dt_model, iris_test)

ml_multiclass_classification_evaluator(pred)
}

}
\seealso{
Other ml algorithms: 
\code{\link{ml_aft_survival_regression}()},
\code{\link{ml_gbt_classifier}()},
\code{\link{ml_generalized_linear_regression}()},
\code{\link{ml_isotonic_regression}()},
\code{\link{ml_linear_regression}()},
\code{\link{ml_linear_svc}()},
\code{\link{ml_logistic_regression}()},
\code{\link{ml_multilayer_perceptron_classifier}()},
\code{\link{ml_naive_bayes}()},
\code{\link{ml_one_vs_rest}()},
\code{\link{ml_random_forest_classifier}()}
}
\concept{ml algorithms}
