% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsegl-methods.R
\name{predict.sparsegl}
\alias{predict.sparsegl}
\title{Make predictions from a \code{sparsegl} object.}
\usage{
\method{predict}{sparsegl}(
  object,
  newx,
  s = NULL,
  type = c("link", "response", "coefficients", "nonzero", "class"),
  ...
)
}
\arguments{
\item{object}{Fitted \code{\link[=sparsegl]{sparsegl()}} model object.}

\item{newx}{Matrix of new values for \code{x} at which predictions are to be
made. Must be a matrix. This argument is mandatory.}

\item{s}{Value(s) of the penalty parameter \code{lambda} at which
predictions are required. Default is the entire sequence used to create the
model.}

\item{type}{Type of prediction required. Type \code{"link"} gives the linear
predictors for \code{"binomial"}; for \code{"gaussian"} models it gives the fitted
values. Type \code{"response"} gives predictions on the scale of the response
(for example, fitted probabilities for \code{"binomial"}); for \code{"gaussian"} type
\code{"response"} is equivalent to type \code{"link"}. Type
\code{"coefficients"} computes the coefficients at the requested values for
\code{s}.
Type \code{"class"} applies only to \code{"binomial"} models, and produces the
class label corresponding to
the maximum probability. Type \code{"nonzero"} returns a list of the indices
of the nonzero coefficients for each value of \code{s}.}

\item{...}{Not used.}
}
\value{
The object returned depends on type.
}
\description{
Similar to other predict methods, this function produces fitted values and
class labels from a fitted \code{\link{sparsegl}} object.
}
\details{
\code{s} is the new vector of \code{lambda} values at which predictions are requested.
If \code{s} is not in the lambda sequence used for fitting the model, the \code{coef}
function will use linear interpolation to make predictions. The new values
are interpolated using a fraction of coefficients from both left and right
\code{lambda} indices.
}
\examples{
n <- 100
p <- 20
X <- matrix(rnorm(n * p), nrow = n)
eps <- rnorm(n)
beta_star <- c(rep(5, 5), c(5, -5, 2, 0, 0), rep(-5, 5), rep(0, (p - 15)))
y <- X \%*\% beta_star + eps
groups <- rep(1:(p / 5), each = 5)
fit1 <- sparsegl(X, y, group = groups)
predict(fit1, newx = X[10, ], s = fit1$lambda[3:5])
}
\seealso{
\code{\link[=sparsegl]{sparsegl()}}, \code{\link[=coef.sparsegl]{coef.sparsegl()}}.
}
