% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_sparta.R
\name{slice}
\alias{slice}
\alias{slice.sparta}
\title{Slice}
\usage{
slice(x, s, drop = FALSE)

\method{slice}{sparta}(x, s, drop = FALSE)
}
\arguments{
\item{x}{sparta object}

\item{s}{a slice in form of a named character vector}

\item{drop}{Logical. If \code{TRUE}, the variables in \code{s} are removed}
}
\value{
A sparta object
}
\description{
Find the slice of a sparse table
}
\examples{

x <- array(
 c(1,0,0,2,3,4,0,0),
 dim = c(2,2,2),
 dimnames = list(
   a = c("a1", "a2"),
   b = c("b1", "b2"),
   c = c("c1", "c2")
 )
)

sx <- as_sparta(x)

# conditional probability table p(b,c|a)
sx <- as_cpt(sx, "a")

# the probability distriubtion when 'a' is 'a2' 
sxa2 <- slice(sx, c(a = "a2"))
get_val(sxa2, c(a = "a2", b = "b1", c = "c2"))

sxa2_drop <- slice(sx, c(a = "a2"), drop = TRUE)
get_val(sxa2_drop, c(b = "b1", c = "c2"))

u <- sparta_unity_struct(dim_names(sx))
slice(u, c(a = "a1"), drop = TRUE)

}
