aa_sampleSizeSummary <-
function(FILEPATH,SAMPLESIZES,MEASURES,ATESTRESULTSFILENAME,SUMMARYFILENAME,TIMEPOINTS=NULL,TIMEPOINTSCALE=NULL)
{
	if(is.null(TIMEPOINTS))
	{
		ATESTMAXES <-NULL

		print("Producing Analysis Summary (aa_sampleSizeSummary)")
		
		# No need to check the measures now we're using check.names=FALSE
		# Check the Measures and Parameters for Spaces - R will have replaced these with a dot
		#MEASURES<-table_header_check(MEASURES)

		if(file.exists(paste(FILEPATH,"/",ATESTRESULTSFILENAME,sep="")))
		{
			# SPARTAN 2.0 - ALL ATEST SCORES ARE NOW IN 1 CSV FILE - OPEN THIS AND PROCESS IT
			ALLSUBSET_ATEST_SCORES<-read.csv(paste(FILEPATH,"/",ATESTRESULTSFILENAME,sep=""),header=TRUE,check.names=FALSE)	

			for(k in 1:length(SAMPLESIZES))
			{
				SAMPLEPROCESSING = SAMPLESIZES[k]
				print(paste("Processing Sample Size: ",SAMPLEPROCESSING,sep=""))

				# SUBSET THE RESULTS ON THE SAMPLE SIZE
				SAMPLE_SIZE_RESULT<-subset(ALLSUBSET_ATEST_SCORES,ALLSUBSET_ATEST_SCORES[["Sample Size"]]==as.numeric(SAMPLEPROCESSING))

				# NOW WORK OUT MAX AND MEDIAN A-TEST RESULTS FOR EACH SAMPLE SIZE, FOR GRAPHING LATER
				SAMPLE_SIZE_SUMMARY<-c(SAMPLEPROCESSING)

				for(MEASURE in 1:length(MEASURES))
				{
					MEASURELABEL<-paste("ATest",MEASURES[MEASURE],"Norm",sep="")
					MEDIANATESTMEASUREVAL <- median(SAMPLE_SIZE_RESULT[MEASURELABEL][,1])
					MAXATESTMEASUREVAL <- max(SAMPLE_SIZE_RESULT[MEASURELABEL][,1])
					SAMPLE_SIZE_SUMMARY<-cbind(SAMPLE_SIZE_SUMMARY,MAXATESTMEASUREVAL,MEDIANATESTMEASUREVAL)

				}

				ATESTMAXES<-rbind(ATESTMAXES,SAMPLE_SIZE_SUMMARY)
			}

			# NOW OUTPUT THE RESULTS
			# GENERATE COL HEADER FOR THE OUTPUT FILE
			OUTPUTCOLHEADS<-c("SampleSize")

			for(l in 1:length(MEASURES))
			{
				OUTPUTCOLHEADS<-cbind(OUTPUTCOLHEADS,paste(MEASURES[l],"MaxA",sep=""),paste(MEASURES[l],"MedianA",sep=""))
			}

			colnames(ATESTMAXES)<-c(OUTPUTCOLHEADS)

			# NOW OUTPUT THESE FOR GRAPHING LATER
			# SUMMARY FILENAME SOMETHING LIKE ATESTMAXANDMEDIANS.CSV FOR ONE TIMEPOINT
			RESULTFILE = paste(FILEPATH,"/",SUMMARYFILENAME,sep="")
			# WRITE OUT SO HAVE THE TABLE IF NECESSARY LATER
			write.csv(ATESTMAXES,RESULTFILE,quote = FALSE,row.names=FALSE)

			print(paste("Summary file of all A-Test results output to ",FILEPATH,"/",SUMMARYFILENAME,sep=""))
		}
		else
		{
			print("Error: Cannot find the A-Test Results file. Check your FILEPATH and SAMPLESIZES parameters")
		}
	}
	else
	{
		for(n in 1:length(TIMEPOINTS))
		{

			TIMEPOINTPROCESSING<-TIMEPOINTS[n]
			print(paste("PROCESSING TIMEPOINT: ",TIMEPOINTPROCESSING,sep=""))

			ATESTRESULTSFILENAME_FORMAT<-substr(ATESTRESULTSFILENAME,(nchar(ATESTRESULTSFILENAME)+1)-3,nchar(ATESTRESULTSFILENAME))
			ATESTRESULTSFILENAME_FULL<-paste(substr(ATESTRESULTSFILENAME,0,nchar(ATESTRESULTSFILENAME)-4),"_",TIMEPOINTPROCESSING,".",ATESTRESULTSFILENAME_FORMAT,sep="")

			SUMMARYFILENAME_FORMAT<-substr(SUMMARYFILENAME,(nchar(SUMMARYFILENAME)+1)-3,nchar(SUMMARYFILENAME))
			SUMMARYFILENAME_FULL<-paste(substr(SUMMARYFILENAME,0,nchar(SUMMARYFILENAME)-4),"_",TIMEPOINTPROCESSING,".",SUMMARYFILENAME_FORMAT,sep="")

			aa_sampleSizeSummary(FILEPATH,SAMPLESIZES,MEASURES,ATESTRESULTSFILENAME_FULL,SUMMARYFILENAME_FULL,TIMEPOINTS=NULL,TIMEPOINTSCALE=NULL)
		
		}

	}
}

