% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emulation_utilities.R
\name{emulator_predictions}
\alias{emulator_predictions}
\title{Used to generate predictions from an emulator, normalising data if required}
\usage{
emulator_predictions(emulation, parameters, measures, data_to_predict,
  normalise = FALSE, normalise_result = FALSE)
}
\arguments{
\item{emulation}{The emulation object to use to make the predictions}

\item{parameters}{Parameters on which the model will take as input}

\item{measures}{Simulation responses the model should predict}

\item{data_to_predict}{Unseen values for the parameters for which the
measures should be predicted}

\item{normalise}{Whether the data_to_predict should be normalised}

\item{normalise_result}{Whether the resultant predictions should be
normalised}
}
\value{
Predictions generated for this unseen data
}
\description{
With an emulator object produced, this can be used to generate predictions
on unseen data. This method is called with the emulation object,
parameters, meaasures, and unseen data. A flag should also be set as to
whether the unseen data, and thus the generated prediction, need to be
normalised and rescaled accordingly. Unseen data being input into the
emulator must be scaled between 0 and 1, with predictions rescaled after
generation.
}
