% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lorenz.R
\name{lorenz}
\alias{lorenz}
\alias{lorenz96}
\title{Lorenz '96 spatPomp simulator}
\usage{
lorenz(
  U = 5,
  N = 100,
  delta_t = 0.01,
  delta_obs = 0.5,
  regular_params = c(F = 8, sigma = 1, tau = 1)
)
}
\arguments{
\item{U}{A length-one numeric signifying the number of spatial units for the process.}

\item{N}{A length-one numeric signifying the number of observations.}

\item{delta_t}{A length-one numeric giving the Euler time step for the numerical solution.}

\item{delta_obs}{A length-one numeric giving the time between observations.}

\item{regular_params}{A named numeric vector containing the values of the \code{F},
\code{sigma} and \code{tau} parameters.
\code{F=8} is a common value that causes chaotic behavior.}
}
\value{
An object of class \sQuote{spatPomp} representing a simulation from a \code{U}-dimensional
Lorenz 96 model
}
\description{
Generate a spatPomp object representing a \code{U}-dimensional stochastic Lorenz '96 process with
\code{N} measurements made at times \eqn{t_n = n * delta_obs}, simulated using an Euler method
with time increment \code{delta_t}.
}
\examples{
# Complete examples are provided in the package tests
\dontrun{
l <- lorenz(U=5, N=100, delta_t=0.01, delta_obs=1)
# See all the model specifications of the object
spy(l)
}
}
\references{
\lorenz96

\ionides2021
}
\seealso{
Other spatPomp model generators: 
\code{\link{bm2}()},
\code{\link{bm}()},
\code{\link{gbm}()},
\code{\link{he10}()},
\code{\link{measles}()}
}
\author{
Edward L. Ionides
}
\concept{spatPomp model generators}
